//
//			16-Input Multiplxer using 8 LUTs, 4 F5, 2 F6 and 1 F7 MUX
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// 4 LUTs form four 2-input multiplexers:
//
//		I2	I1	I0	O
//		0	0	0	0
//		0	0	1	1
//		0	1	0	0
//		0	1	1	1
//		1	0	0	0
//		1	0	1	0
//		1	1	0	1
//		1	1	1	1
//
// and are combined with 7 dedicated multiplexers (F5, F6 and F7). 
//
module MUX16(D, S, Y);
    input [15:0] D;	// data inputs
    input [3:0] S;	// select
    output Y;			// data output
// internal signals
wire y0,y1,y2,y3,y4,y5,y6,y7,y01,y23,y45,y67,y0123,y4567;	// outputs of LUTs
// internal logic - use LUT local outputs and MUX local inputs
LUT3_L #(.INIT(8'hCA)) lut0 (.I0(D[0]), .I1(D[1]), .I2(S[0]), .LO(y0));
LUT3_L #(.INIT(8'hCA)) lut1 (.I0(D[2]), .I1(D[3]), .I2(S[0]), .LO(y1));
LUT3_L #(.INIT(8'hCA)) lut2 (.I0(D[4]), .I1(D[5]), .I2(S[0]), .LO(y2));
LUT3_L #(.INIT(8'hCA)) lut3 (.I0(D[6]), .I1(D[7]), .I2(S[0]), .LO(y3));
LUT3_L #(.INIT(8'hCA)) lut4 (.I0(D[8]), .I1(D[9]), .I2(S[0]), .LO(y4));
LUT3_L #(.INIT(8'hCA)) lut5 (.I0(D[10]), .I1(D[11]), .I2(S[0]), .LO(y5));
LUT3_L #(.INIT(8'hCA)) lut6 (.I0(D[12]), .I1(D[13]), .I2(S[0]), .LO(y6));
LUT3_L #(.INIT(8'hCA)) lut7 (.I0(D[14]), .I1(D[15]), .I2(S[0]), .LO(y7));
MUXF5_L mux0 (.I0(y0), .I1(y1), .S(S[1]), .LO(y01));
MUXF5_L mux1 (.I0(y2), .I1(y3), .S(S[1]), .LO(y23));
MUXF5_L mux2 (.I0(y4), .I1(y5), .S(S[1]), .LO(y45));
MUXF5_L mux3 (.I0(y6), .I1(y7), .S(S[1]), .LO(y67));
MUXF6_L mux4 (.I0(y01), .I1(y23), .S(S[2]), .LO(y0123));
MUXF6_L mux5 (.I0(y45), .I1(y67), .S(S[2]), .LO(y4567));
MUXF7 mux6 (.I0(y0123), .I1(y4567), .S(S[3]), .O(Y));
endmodule
