//
//							2-Input Multiplxer with Latch
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// 1 LUT forms a 2-input multiplexer:
//
//		I3	I2	I1	I0	O	
//		0	0	0	0	0	A
//		0	0	0	1	1	A
//		0	0	1	0	0	A
//		0	0	1	1	1	A
//		0	1	0	0	0	B
//		0	1	0	1	0	B
//		0	1	1	0	1	B
//		0	1	1	1	1	B
//
module MUX2S(D, S, Q, CE, CLK, RST);
    input [1:0] D;	// data inputs
    input S;			// select
    output Q;			// data output
	 input CE;			// clock enable
	 input CLK;			// master clock
	 input RST;			// synchronous reset
// internal signals
wire y;	// outputs of LUTs and multiplexer
// internal logic - use LUT local outputs and MUX local inputs
LUT3_L #(.INIT(8'hCA)) lut (.I0(D[0]), .I1(D[1]), .I2(S), .LO(y));
FDRSE ff (.D(y), .C(CLK), .CE(CE), .R(RST), .S(1'b0), .Q(Q));
endmodule
