//
//						 2 x 28-bit Multiplexer with Latch
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
module MUX2X28S(D0, D1, S, Q, CE, CLK, RST);
    input [27:0] D0,D1;	// input ports
    input S;				// select input
    output [27:0] Q;		// output port
	 input CE;				// clock enable
	 input CLK;				// clock output latch
	 input RST;				// reset output latch
// 28 copies of MUX2S
MUX2S mux0 (.D({D1[0],D0[0]}), .S(S), .Q(Q[0]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux1 (.D({D1[1],D0[1]}), .S(S), .Q(Q[1]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux2 (.D({D1[2],D0[2]}), .S(S), .Q(Q[2]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux3 (.D({D1[3],D0[3]}), .S(S), .Q(Q[3]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux4 (.D({D1[4],D0[4]}), .S(S), .Q(Q[4]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux5 (.D({D1[5],D0[5]}), .S(S), .Q(Q[5]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux6 (.D({D1[6],D0[6]}), .S(S), .Q(Q[6]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux7 (.D({D1[7],D0[7]}), .S(S), .Q(Q[7]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux8 (.D({D1[8],D0[8]}), .S(S), .Q(Q[8]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux9 (.D({D1[9],D0[9]}), .S(S), .Q(Q[9]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux10 (.D({D1[10],D0[10]}), .S(S), .Q(Q[10]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux11 (.D({D1[11],D0[11]}), .S(S), .Q(Q[11]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux12 (.D({D1[12],D0[12]}), .S(S), .Q(Q[12]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux13 (.D({D1[13],D0[13]}), .S(S), .Q(Q[13]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux14 (.D({D1[14],D0[14]}), .S(S), .Q(Q[14]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux15 (.D({D1[15],D0[15]}), .S(S), .Q(Q[15]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux16 (.D({D1[16],D0[16]}), .S(S), .Q(Q[16]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux17 (.D({D1[17],D0[17]}), .S(S), .Q(Q[17]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux18 (.D({D1[18],D0[18]}), .S(S), .Q(Q[18]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux19 (.D({D1[19],D0[19]}), .S(S), .Q(Q[19]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux20 (.D({D1[20],D0[20]}), .S(S), .Q(Q[20]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux21 (.D({D1[21],D0[21]}), .S(S), .Q(Q[21]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux22 (.D({D1[22],D0[22]}), .S(S), .Q(Q[22]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux23 (.D({D1[23],D0[23]}), .S(S), .Q(Q[23]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux24 (.D({D1[24],D0[24]}), .S(S), .Q(Q[24]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux25 (.D({D1[25],D0[25]}), .S(S), .Q(Q[25]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux26 (.D({D1[26],D0[26]}), .S(S), .Q(Q[26]), .CE(CE), .CLK(CLK), .RST(RST));
MUX2S mux27 (.D({D1[27],D0[27]}), .S(S), .Q(Q[27]), .CE(CE), .CLK(CLK), .RST(RST));
endmodule
