//
//					4-Input Multiplxer using 2 LUTs and F5 MUX
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// 2 LUTs form two 2-input multiplexers:
//
//		I2	I1	I0	O
//		0	0	0	0
//		0	0	1	1
//		0	1	0	0
//		0	1	1	1
//		1	0	0	0
//		1	0	1	0
//		1	1	0	1
//		1	1	1	1
//
// and 2 are combined with dedicated multiplexer F5.
//
module MUX4(D, S, Y);
    input [3:0] D;	// data inputs
    input [1:0] S;	// select
    output Y;			// data output
// internal signals
wire y0,y1;	// outputs of two LUTs
// internal logic - use LUT local outputs and MUX local inputs
LUT3_L #(.INIT(8'hCA)) lut0 (.I0(D[0]), .I1(D[1]), .I2(S[0]), .LO(y0));
LUT3_L #(.INIT(8'hCA)) lut1 (.I0(D[2]), .I1(D[3]), .I2(S[0]), .LO(y1));
MUXF5 mux (.I0(y0), .I1(y1), .S(S[1]), .O(Y));
endmodule
