//
//			4-Input Multiplxer with Inverter using 2 LUTs and F5 MUX
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// 2 LUTs form two 2-input multiplexers:
//
//		I3	I2	I1	I0	O	
//		0	0	0	0	0	A
//		0	0	0	1	1	A
//		0	0	1	0	0	A
//		0	0	1	1	1	A
//		0	1	0	0	0	B
//		0	1	0	1	0	B
//		0	1	1	0	1	B
//		0	1	1	1	1	B
//		1	0	0	0	1	~A
//		1	0	0	1	0	~A
//		1	0	1	0	1	~A
//		1	0	1	1	0	~A
//		1	1	0	0	1	~B
//		1	1	0	1	1	~B
//		1	1	1	0	0	~B
//		1	1	1	1	0	~B
//
// and 2 are combined with dedicated multiplexer F5.
//
module MUX4I(D, S, I, Y);
    input [3:0] D;	// data inputs
    input [1:0] S;	// select
	 input I;			// invert
    output Y;			// data output
// internal signals
wire y0,y1;	// outputs of two LUTs
// internal logic - use LUT local outputs and MUX local inputs
LUT4_L #(.INIT(16'h35CA)) lut0 (.I0(D[0]), .I1(D[1]), .I2(S[0]), .I3(I), .LO(y0));
LUT4_L #(.INIT(16'h35CA)) lut1 (.I0(D[2]), .I1(D[3]), .I2(S[0]), .I3(I), .LO(y1));
MUXF5 mux (.I0(y0), .I1(y1), .S(S[1]), .O(Y));
endmodule
