//
//							4-Input Multiplxer with Latch
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// 2 LUTs form two 2-input multiplexers:
//
//		I3	I2	I1	I0	O	
//		0	0	0	0	0	A
//		0	0	0	1	1	A
//		0	0	1	0	0	A
//		0	0	1	1	1	A
//		0	1	0	0	0	B
//		0	1	0	1	0	B
//		0	1	1	0	1	B
//		0	1	1	1	1	B
//
// and are combined with dedicated multiplexer F5.
//
module MUX4S(D, S, Q, CE, CLK, RST);
    input [3:0] D;	// data inputs
    input [1:0] S;	// select
    output Q;			// data output
	 input CE;			// clock enable
	 input CLK;			// master clock
	 input RST;			// synchronous reset
// internal signals
wire y0,y1,y01;	// outputs of LUTs and multiplexer
// internal logic - use LUT local outputs and MUX local inputs
LUT3_L #(.INIT(8'hCA)) lut0 (.I0(D[0]), .I1(D[1]), .I2(S[0]), .LO(y0));
LUT3_L #(.INIT(8'hCA)) lut1 (.I0(D[2]), .I1(D[3]), .I2(S[0]), .LO(y1));
MUXF5_L mux (.I0(y0), .I1(y1), .S(S[1]), .LO(y01));
FDRSE ff (.D(y01), .C(CLK), .CE(CE), .R(RST), .S(1'b0), .Q(Q));
endmodule
