//
//				8-Input Multiplxer using 4 LUTs, 2 F5 and 1 F6 MUX
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// 4 LUTs form four 2-input multiplexers:
//
//		I2	I1	I0	O
//		0	0	0	0
//		0	0	1	1
//		0	1	0	0
//		0	1	1	1
//		1	0	0	0
//		1	0	1	0
//		1	1	0	1
//		1	1	1	1
//
// and are combined with 3 dedicated multiplexers (F5 and F6). 
//
module MUX8(D, S, Y);
    input [7:0] D;	// data inputs
    input [2:0] S;	// select
    output Y;			// data output
// internal signals
wire y0,y1,y2,y3,y01,y23;	// outputs of two LUTs
// internal logic - use LUT local outputs and MUX local inputs
LUT3_L #(.INIT(8'hCA)) lut0 (.I0(D[0]), .I1(D[1]), .I2(S[0]), .LO(y0));
LUT3_L #(.INIT(8'hCA)) lut1 (.I0(D[2]), .I1(D[3]), .I2(S[0]), .LO(y1));
LUT3_L #(.INIT(8'hCA)) lut2 (.I0(D[4]), .I1(D[5]), .I2(S[0]), .LO(y2));
LUT3_L #(.INIT(8'hCA)) lut3 (.I0(D[6]), .I1(D[7]), .I2(S[0]), .LO(y3));
MUXF5_L mux01 (.I0(y0), .I1(y1), .S(S[1]), .LO(y01));
MUXF5_L mux23 (.I0(y2), .I1(y3), .S(S[1]), .LO(y23));
MUXF6 mux (.I0(y01), .I1(y23), .S(S[2]), .O(Y));
endmodule
