//
//			RAM32X16D - Dual-Port Distributed RAM - 32 16-bit words
//
//					(C) Copyright 2007-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
//	This RAM has one write port and 2 read ports and occupies 16 slices.
// Port A is read/write and port B is read only. Reading is asynchronous
// and writing is synchronous to WCLK when WEL or WEH are true.
//
// Uses 18 slices (68 LUTs).
//
module RAM32X16D(AA, AB, DA, YA, YB, WEL, WEH, WCLK);
    input [4:0] AA;		// port A address
    input [4:0] AB;		// port B address
    input [15:0] DA;		// port A data input
    output [15:0] YA;	// port A data output
    output [15:0] YB;	// port B data output
    input WEL;				// write enable for LSB of port A
    input WEH;				// write enable for MSB of port A
    input WCLK;			// write clock for port A
// Use 16 RAM32X1DP
RAM32X1DP ram0 (.AA(AA), .DA(DA[0]), .WE(WEL), .WCLK(WCLK), .YA(YA[0]), .AB(AB), .YB(YB[0]));
RAM32X1DP ram1 (.AA(AA), .DA(DA[1]), .WE(WEL), .WCLK(WCLK), .YA(YA[1]), .AB(AB), .YB(YB[1]));
RAM32X1DP ram2 (.AA(AA), .DA(DA[2]), .WE(WEL), .WCLK(WCLK), .YA(YA[2]), .AB(AB), .YB(YB[2]));
RAM32X1DP ram3 (.AA(AA), .DA(DA[3]), .WE(WEL), .WCLK(WCLK), .YA(YA[3]), .AB(AB), .YB(YB[3]));
RAM32X1DP ram4 (.AA(AA), .DA(DA[4]), .WE(WEL), .WCLK(WCLK), .YA(YA[4]), .AB(AB), .YB(YB[4]));
RAM32X1DP ram5 (.AA(AA), .DA(DA[5]), .WE(WEL), .WCLK(WCLK), .YA(YA[5]), .AB(AB), .YB(YB[5]));
RAM32X1DP ram6 (.AA(AA), .DA(DA[6]), .WE(WEL), .WCLK(WCLK), .YA(YA[6]), .AB(AB), .YB(YB[6]));
RAM32X1DP ram7 (.AA(AA), .DA(DA[7]), .WE(WEL), .WCLK(WCLK), .YA(YA[7]), .AB(AB), .YB(YB[7]));
RAM32X1DP ram8 (.AA(AA), .DA(DA[8]), .WE(WEH), .WCLK(WCLK), .YA(YA[8]), .AB(AB), .YB(YB[8]));
RAM32X1DP ram9 (.AA(AA), .DA(DA[9]), .WE(WEH), .WCLK(WCLK), .YA(YA[9]), .AB(AB), .YB(YB[9]));
RAM32X1DP ram10 (.AA(AA), .DA(DA[10]), .WE(WEH), .WCLK(WCLK), .YA(YA[10]), .AB(AB), .YB(YB[10]));
RAM32X1DP ram11 (.AA(AA), .DA(DA[11]), .WE(WEH), .WCLK(WCLK), .YA(YA[11]), .AB(AB), .YB(YB[11]));
RAM32X1DP ram12 (.AA(AA), .DA(DA[12]), .WE(WEH), .WCLK(WCLK), .YA(YA[12]), .AB(AB), .YB(YB[12]));
RAM32X1DP ram13 (.AA(AA), .DA(DA[13]), .WE(WEH), .WCLK(WCLK), .YA(YA[13]), .AB(AB), .YB(YB[13]));
RAM32X1DP ram14 (.AA(AA), .DA(DA[14]), .WE(WEH), .WCLK(WCLK), .YA(YA[14]), .AB(AB), .YB(YB[14]));
RAM32X1DP ram15 (.AA(AA), .DA(DA[15]), .WE(WEH), .WCLK(WCLK), .YA(YA[15]), .AB(AB), .YB(YB[15]));
endmodule
