//
//			RAM32X1DP - Dual-Port Distributed RAM - 32 1-bit words
//
//					(C) Copyright 2007-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// 3 slices used (6 LUTs).
//
module RAM32X1DP(
    input [4:0] AA,	// read/write port address
    input [4:0] AB,	// read-only port address
    input DA,			// read/write port data in
    output YA,			// read/write port data out
    output YB,			// read-only port data out
    input WE,			// write enable
    input WCLK			// write clock
    );
// internal signals
wire YA0,YA1,YB0,YB1;	// multiplexer inputs
// Use 2 RAM16X1D
RAM16X1D ram0 (.A0(AA[0]), .A1(AA[1]), .A2(AA[2]), .A3(AA[3]), .D(DA), .WE(WE & ~AA[4]), .WCLK(WCLK), .SPO(YA0),
					.DPRA0(AB[0]), .DPRA1(AB[1]), .DPRA2(AB[2]), .DPRA3(AB[3]), .DPO(YB0));
RAM16X1D ram1 (.A0(AA[0]), .A1(AA[1]), .A2(AA[2]), .A3(AA[3]), .D(DA), .WE(WE & AA[4]), .WCLK(WCLK), .SPO(YA1),
					.DPRA0(AB[0]), .DPRA1(AB[1]), .DPRA2(AB[2]), .DPRA3(AB[3]), .DPO(YB1));
// multiplex outputs
assign YA = AA[4] ? YA1 : YA0;
assign YB = AB[4] ? YB1 : YB0;
endmodule
