//
//					32-bit Adjustable-length Shift register
//
//					(C) Copyright 2004 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
//	1 slice. 275 MHz.
//
module SRL32E(Q,D,A0,A1,A2,A3,A4,CE,CLK);
    output Q;
    input D;
    input A0;
    input A1;
    input A2;
    input A3;
    input A4;
    input CE;
    input CLK;
// 2 shift registers and 1 multiplexer
wire q15;	// inter-SRLC16E	bits
wire qa,qb;	// SRL16E outputs
SRLC16E sr1 (.D(D), .A0(A0), .A1(A1), .A2(A2), .A3(A3), .Q(qa), .Q15(q15), .CE(CE), .CLK(CLK));
SRLC16E sr2 (.D(q15), .A0(A0), .A1(A1), .A2(A2), .A3(A3), .Q(qb), .Q15(), .CE(CE), .CLK(CLK));
MUXF5 mux1 (.I0(qa), .I1(qb), .S(A4), .O(Q));
endmodule
