//
//					64-bit Adjustable-length Shift register
//
//					(C) Copyright 2004 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
//	4 slices. 258 MHz.
//
module SRL64E(Q,D,A0,A1,A2,A3,A4,A5,CE,CLK);
    output Q;
    input D;
    input A0;
    input A1;
    input A2;
    input A3;
    input A4;
    input A5;
    input CE;
    input CLK;
// 4 shift registers and 3 multiplexers
wire q15,q31,q47;	// inter-SRLC16E	bits
wire qa,qb,qc,qd;	// SRL16E outputs
SRLC16E sr1 (.D(D), .A0(A0), .A1(A1), .A2(A2), .A3(A3), .Q(qa), .Q15(q15), .CE(CE), .CLK(CLK));
SRLC16E sr2 (.D(q15), .A0(A0), .A1(A1), .A2(A2), .A3(A3), .Q(qb), .Q15(q31), .CE(CE), .CLK(CLK));
SRLC16E sr3 (.D(q31), .A0(A0), .A1(A1), .A2(A2), .A3(A3), .Q(qc), .Q15(q47), .CE(CE), .CLK(CLK));
SRLC16E sr4 (.D(q47), .A0(A0), .A1(A1), .A2(A2), .A3(A3), .Q(qd), .Q15(), .CE(CE), .CLK(CLK));
wire qab,qcd;	// inter-MUX bits
MUXF5_L mux1 (.I0(qa), .I1(qb), .S(A4), .LO(qab));
MUXF5_L mux2 (.I0(qc), .I1(qd), .S(A4), .LO(qcd));
MUXF6 mux3 (.I0(qab), .I1(qcd), .S(A5), .O(Q));
endmodule
