// 1024 x 18 Sine ROM with output latches
// (C) Copyright 2008 John B. Stephensen  All rights reserved.
module Sine1k2 (aa, ab, da, db, clk, rst);
   input [9:0] aa,ab;   // address ports
   output [17:0] da,db; // data read ports
   input clk;           // common clock
   input rst;           // read port reset
// internal signals
wire [17:0] a,b; // ROM outputs
// block RAM
RAMB16_S18_S18 #(
   .INIT_00(256'h2F0F2BEE28CC25AA22881F651C42191F15FC12D80FB50C91096D064803240000),
   .INIT_01(256'h60CD5DB75AA05788546F51564E3B4B20480444E841CA3EAC3B8E386F354F322F),
   .INIT_02(256'h919E8E9A8B95888E8587827D7F737C68795B764D733E702E6D1D6A0A66F763E3),
   .INIT_03(256'hC107BE1DBB31B844B555B264AF71AC7CA986A68FA395A09B9D9E9AA097A194A0),
   .INIT_04(256'hEE94EBCBE900E633E363E092DDBEDAE8D810D536D25ACF7BCC9BC9B9C6D5C3EF),
   .INIT_05(256'h19D51734149111EB0F420C9609E80738048501CFFF17FC5DF9A0F6E0F41FF15A),
   .INIT_06(256'h425F3FED3D773AFF38833605338330FF2E772BED296026D0243D21A71F0E1C73),
   .INIT_07(256'h67CF6591634F610B5EC35C775A2857D65580532750CB4E6C4C0949A4473B44CF),
   .INIT_08(256'h89C787C385BB83B081A17F8E7D777B5D793F771E74F872D070A36E736C406A09),
   .INIT_09(256'hA7F5A630A467A29AA0C89EF39D1A9B3D995C9777958E93A191B18FBC8DC38BC7),
   .INIT_0A(256'hC20DC08BBF05BD7BBBEDBA5AB8C3B727B588B3E4B23CB090AEDFAD2BAB72A9B5),
   .INIT_0B(256'hD7D0D695D556D412D2CAD17ED02CCED7CD7DCC1ECABBC954C7E8C678C503C38A),
   .INIT_0C(256'hE907E817E721E628E529E426E31EE211E100DFEADECFDDB0DC8DDB64DA37D906),
   .INIT_0D(256'hF589F4E5F43CF38EF2DCF224F168F0A7EFE1EF17EE47ED73EC9AEBBDEADAE9F3),
   .INIT_0E(256'hFD37FCE0FC85FC25FBC0FB57FAE8FA74F9FCF97FF8FCF875F7E9F759F6C3F628),
   .INIT_0F(256'hFFFDFFF5FFE9FFD8FFC1FFA6FF86FF61FF37FF08FED5FE9CFE5EFE1CFDD4FD88),
   .INIT_10(256'hFDD4FE1CFE5EFE9CFED5FF08FF37FF61FF86FFA6FFC1FFD8FFE9FFF5FFFDFFFF),
   .INIT_11(256'hF6C3F759F7E9F875F8FCF97FF9FCFA74FAE8FB57FBC0FC25FC85FCE0FD37FD88),
   .INIT_12(256'hEADAEBBDEC9AED73EE47EF17EFE1F0A7F168F224F2DCF38EF43CF4E5F589F629),
   .INIT_13(256'hDA37DB64DC8DDDB0DED0DFEAE100E211E31EE426E529E628E722E817E907E9F3),
   .INIT_14(256'hC503C678C7E8C954CABBCC1ECD7DCED7D02CD17ED2CAD412D556D695D7D0D906),
   .INIT_15(256'hAB72AD2BAEE0B090B23CB3E4B588B727B8C3BA5ABBEDBD7BBF06C08BC20DC38A),
   .INIT_16(256'h8DC48FBC91B193A2958E9777995C9B3D9D1A9EF4A0C9A29AA467A630A7F5A9B6),
   .INIT_17(256'h6C406E7470A472D074F9771E793F7B5D7D787F8E81A183B085BC87C389C78BC7),
   .INIT_18(256'h473B49A44C0A4E6C50CC5328558157D65A285C775EC3610B6350659167CF6A09),
   .INIT_19(256'h1F0F21A7243D26D029602BED2E7830FF3384360538843AFF3D783FED426044CF),
   .INIT_1A(256'hF41FF6E1F9A0FC5DFF1701D00485073809E90C970F4211EB1491173519D51C73),
   .INIT_1B(256'hC6D5C9B9CC9BCF7CD25AD536D810DAE8DDBEE092E364E633E901EBCCEE94F15B),
   .INIT_1C(256'h97A19AA19D9EA09BA396A68FA987AC7DAF71B264B555B844BB32BE1DC107C3EF),
   .INIT_1D(256'h66F76A0B6D1D702E733E764D795B7C687F74827E8587888F8B958E9A919E94A0),
   .INIT_1E(256'h3550386F3B8E3EAD41CB44E848054B204E3C5156547057885AA05DB860CE63E3),
   .INIT_1F(256'h03250649096D0C910FB512D915FC19201C431F66228825AB28CC2BEE2F0F3230),
   .INIT_20(256'hD0F2D413D734DA56DD78E09BE3BEE6E1EA04ED28F04CF370F694F9B8FCDC0000),
   .INIT_21(256'h9F33A249A560A878AB91AEABB1C5B4E0B7FCBB19BE36C154C472C791CAB1CDD1),
   .INIT_22(256'h6E637167746C77727A7A7D83808D839986A589B38CC28FD392E495F699099C1E),
   .INIT_23(256'h3EFA41E344CF47BD4AAC4D9D508F5384567A59725C6B5F666262656068606B60),
   .INIT_24(256'h116C1435170019CD1C9D1F6E2242251827F02ACB2DA7308533653647392C3C12),
   .INIT_25(256'hE62BE8CCEB70EE16F0BEF36AF618F8C8FB7BFE3100E903A4066109200BE20EA6),
   .INIT_26(256'hBDA1C013C289C501C77DC9FBCC7DCF01D189D413D6A0D931DBC4DE59E0F2E38D),
   .INIT_27(256'h98329A6F9CB19EF6A13EA389A5D8A82AAA80ACD9AF35B194B3F7B65DB8C6BB32),
   .INIT_28(256'h7639783D7A457C507E5F8072828984A386C188E38B088D318F5D918D93C095F7),
   .INIT_29(256'h580C59D15B9A5D675F38610D62E664C366A468896A726C5F6E507044723D7439),
   .INIT_2A(256'h3DF33F7540FB4285441445A6473E48D94A784C1C4DC44F70512152D5548E564B),
   .INIT_2B(256'h2830296B2AAA2BEE2D362E832FD43129328433E2354536AC381839883AFD3C76),
   .INIT_2C(256'h16F917E918DF19D91AD71BDA1CE21DEF1F002016213122502374249C25C926FA),
   .INIT_2D(256'h0A770B1B0BC40C720D240DDC0E980F59101F10EA11B9128D136614441526160D),
   .INIT_2E(256'h02C90320037B03DB044004A90518058C060406810704078B081708A7093D09D8),
   .INIT_2F(256'h0003000B00170028003F005A007A009F00C900F8012B016401A201E4022C0278),
   .INIT_30(256'h022C01E401A20164012B00F800C9009F007A005A003F00280017000B00030001),
   .INIT_31(256'h093D08A70817078B070406810604058C051804A9044003DB037B032002C90278),
   .INIT_32(256'h152614431366128D11B910E9101F0F590E980DDC0D240C720BC40B1B0A7709D7),
   .INIT_33(256'h25C8249C2373224F213020161F001DEF1CE21BDA1AD719D818DE17E916F9160D),
   .INIT_34(256'h3AFC3988381836AC354533E2328331292FD32E822D362BED2AAA296B283026FA),
   .INIT_35(256'h548D52D551204F704DC44C1C4A7848D8473D45A64413428540FA3F743DF33C75),
   .INIT_36(256'h723C70446E4F6C5E6A71688966A364C262E5610C5F375D665B9959D0580B564A),
   .INIT_37(256'h93BF918C8F5C8D308B0788E286C084A2828880727E5F7C4F7A44783C76387438),
   .INIT_38(256'hB8C5B65CB3F6B194AF34ACD8AA7FA82AA5D7A388A13D9EF59CB09A6F983195F6),
   .INIT_39(256'hE0F1DE58DBC3D930D6A0D412D188CF01CC7CC9FBC77CC500C288C013BDA0BB31),
   .INIT_3A(256'h0BE1091F066003A300E8FE30FB7BF8C7F617F369F0BEEE15EB6FE8CBE62AE38C),
   .INIT_3B(256'h392B3646336430842DA62ACA27EF251722411F6E1C9C19CC16FF1434116B0EA5),
   .INIT_3C(256'h685F655F62615F655C6A597156795383508E4D9C4AAB47BC44CE41E23EF93C11),
   .INIT_3D(256'h990895F592E38FD28CC189B286A48398808C7D827A797771746B71666E626B5F),
   .INIT_3E(256'hCAB0C790C471C153BE35BB18B7FBB4DFB1C4AEAAAB90A877A55FA2489F329C1D),
   .INIT_3F(256'hFCDBF9B7F693F36FF04BED27EA03E6E0E3BDE09ADD77DA55D733D412D0F1CDD0),
   .INITP_00(256'h5555555555555555555550000000000000000000000000000000000000000000),
   .INITP_01(256'h5555555555555555555555555555555555555555555555555555555555555555),
   .INITP_02(256'h5555555555555555555555555555555555555555555555555555555555555555),
   .INITP_03(256'h0000000000000000000000000000000000000000001555555555555555555555),
   .INITP_04(256'hAAAAAAAAAAAAAAAAAAAAAFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC),
   .INITP_05(256'hAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA),
   .INITP_06(256'hAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA),
   .INITP_07(256'hFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEAAAAAAAAAAAAAAAAAAAAA)
   ) rom0 (
   .ADDRA(aa),
   .DIA(16'hFFFF),
   .DIPA(2'b11),
   .DOA(a[15:0]),
   .DOPA(a[17:16]),
   .CLKA(clk),
   .WEA(1'b0),
   .ENA(1'b1),
   .SSRA(rst),
   .ADDRB(ab),
   .DIB(16'hFFFF),
   .DIPB(2'b11),
   .DOB(b[15:0]),
   .DOPB(b[17:16]),
   .CLKB(clk),
   .WEB(1'b0),
   .ENB(1'b1),
   .SSRB(rst)
   );
	// latch outputs
	reg18 ra (
		.d(a),
		.q(da),
		.clk(clk),
		.ce(1'b1),
		.rst(rst)
	);
	reg18 rb (
		.d(b),
		.q(db),
		.clk(clk),
		.ce(1'b1),
		.rst(rst)
	);
endmodule
