//
//				acc32a.v - 32-bit accumulator with unregistered output
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This accumulator supports loading the input, loading the 2's complement
// of the input, adding to or subtracting from the current value.
//
//		ACC	SUB	Operation
//		 0		 0		A = B
//		 0		 1		A = -B
//		 1		 0		A = A + B
//		 1		 1		A = A - B
//
// 17 slices used. 180 MHz maximum clock rate.
//
module acc32a (
    input SUB,
	 input ACC,
    input [31:0] B,
    output [31:0] Y,
    output [31:0] Q,
	 output CO,
    input CLK,
	 input CE,
	 input SCLR
    );
// internal signals
wire [30:0] c;	// carry propogation
// use 32 one-bit accumulators
acc1as a31 (.SUB(SUB), .ACC(ACC), .B(B[31]), .CI(c[30]), .CO(CO), .Y(Y[31]), .Q(Q[31]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a30 (.SUB(SUB), .ACC(ACC), .B(B[30]), .CI(c[29]), .CO(c[30]), .Y(Y[30]), .Q(Q[30]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a29 (.SUB(SUB), .ACC(ACC), .B(B[29]), .CI(c[28]), .CO(c[29]), .Y(Y[29]), .Q(Q[29]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a28 (.SUB(SUB), .ACC(ACC), .B(B[28]), .CI(c[27]), .CO(c[28]), .Y(Y[28]), .Q(Q[28]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a27 (.SUB(SUB), .ACC(ACC), .B(B[27]), .CI(c[26]), .CO(c[27]), .Y(Y[27]), .Q(Q[27]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a26 (.SUB(SUB), .ACC(ACC), .B(B[26]), .CI(c[25]), .CO(c[26]), .Y(Y[26]), .Q(Q[26]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a25 (.SUB(SUB), .ACC(ACC), .B(B[25]), .CI(c[24]), .CO(c[25]), .Y(Y[25]), .Q(Q[25]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a24 (.SUB(SUB), .ACC(ACC), .B(B[24]), .CI(c[23]), .CO(c[24]), .Y(Y[24]), .Q(Q[24]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a23 (.SUB(SUB), .ACC(ACC), .B(B[23]), .CI(c[22]), .CO(c[23]), .Y(Y[23]), .Q(Q[23]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a22 (.SUB(SUB), .ACC(ACC), .B(B[22]), .CI(c[21]), .CO(c[22]), .Y(Y[22]), .Q(Q[22]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a21 (.SUB(SUB), .ACC(ACC), .B(B[21]), .CI(c[20]), .CO(c[21]), .Y(Y[21]), .Q(Q[21]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a20 (.SUB(SUB), .ACC(ACC), .B(B[20]), .CI(c[19]), .CO(c[20]), .Y(Y[20]), .Q(Q[20]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a19 (.SUB(SUB), .ACC(ACC), .B(B[19]), .CI(c[18]), .CO(c[19]), .Y(Y[19]), .Q(Q[19]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a18 (.SUB(SUB), .ACC(ACC), .B(B[18]), .CI(c[17]), .CO(c[18]), .Y(Y[18]), .Q(Q[18]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a17 (.SUB(SUB), .ACC(ACC), .B(B[17]), .CI(c[16]), .CO(c[17]), .Y(Y[17]), .Q(Q[17]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a16 (.SUB(SUB), .ACC(ACC), .B(B[16]), .CI(c[15]), .CO(c[16]), .Y(Y[16]), .Q(Q[16]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a15 (.SUB(SUB), .ACC(ACC), .B(B[15]), .CI(c[14]), .CO(c[15]), .Y(Y[15]), .Q(Q[15]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a14 (.SUB(SUB), .ACC(ACC), .B(B[14]), .CI(c[13]), .CO(c[14]), .Y(Y[14]), .Q(Q[14]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a13 (.SUB(SUB), .ACC(ACC), .B(B[13]), .CI(c[12]), .CO(c[13]), .Y(Y[13]), .Q(Q[13]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a12 (.SUB(SUB), .ACC(ACC), .B(B[12]), .CI(c[11]), .CO(c[12]), .Y(Y[12]), .Q(Q[12]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a11 (.SUB(SUB), .ACC(ACC), .B(B[11]), .CI(c[10]), .CO(c[11]), .Y(Y[11]), .Q(Q[11]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a10 (.SUB(SUB), .ACC(ACC), .B(B[10]), .CI(c[9]), .CO(c[10]), .Y(Y[10]), .Q(Q[10]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a9 (.SUB(SUB), .ACC(ACC), .B(B[9]), .CI(c[8]), .CO(c[9]), .Y(Y[9]), .Q(Q[9]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a8 (.SUB(SUB), .ACC(ACC), .B(B[8]), .CI(c[7]), .CO(c[8]), .Y(Y[8]), .Q(Q[8]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a7 (.SUB(SUB), .ACC(ACC), .B(B[7]), .CI(c[6]), .CO(c[7]), .Y(Y[7]), .Q(Q[7]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a6 (.SUB(SUB), .ACC(ACC), .B(B[6]), .CI(c[5]), .CO(c[6]), .Y(Y[6]), .Q(Q[6]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a5 (.SUB(SUB), .ACC(ACC), .B(B[5]), .CI(c[4]), .CO(c[5]), .Y(Y[5]), .Q(Q[5]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a4 (.SUB(SUB), .ACC(ACC), .B(B[4]), .CI(c[3]), .CO(c[4]), .Y(Y[4]), .Q(Q[4]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a3 (.SUB(SUB), .ACC(ACC), .B(B[3]), .CI(c[2]), .CO(c[3]), .Y(Y[3]), .Q(Q[3]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a2 (.SUB(SUB), .ACC(ACC), .B(B[2]), .CI(c[1]), .CO(c[2]), .Y(Y[2]), .Q(Q[2]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a1 (.SUB(SUB), .ACC(ACC), .B(B[1]), .CI(c[0]), .CO(c[1]), .Y(Y[1]), .Q(Q[1]), .CLK(CLK), .CE(CE), .RST(SCLR));
acc1as a0 (.SUB(SUB), .ACC(ACC), .B(B[0]), .CI(SUB), .CO(c[0]), .Y(Y[0]), .Q(Q[0]), .CLK(CLK), .CE(CE), .RST(SCLR));
endmodule
