//
//								add1s.v - 1-bit adder
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This implementation uses a LUT2 as a half adder (XOR) followed by MUXCY to
// implement ripple carry and XORCY to complete a full adder.
//
//		I1	I0	O
//		0	0	0
//		0	1	1
//		1	0	1
//		1	1	0
//
module add1s(
    input A,
    input B,
    input CI,
    output CO,
    output Q,
    input CLK,
	 input CE,
	 input RST
    );
// internal signals
wire h;	// half-adder output
wire f;	// full-adder output
// half adder
LUT2_L #(.INIT(4'h6)) ha (.I0(A), .I1(B), .LO(h));
MUXCY_L cp (.CI(CI), .DI(A), .S(h), .LO(CO));
XORCY_L fa (.CI(CI), .LI(h), .LO(f));
FDRSE ff (.D(f), .C(CLK), .CE(CE), .R(RST), .S(1'b0), .Q(Q));
endmodule
