//
//								add28s.v - 28-bit adder
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This implementation uses a LUT2 as a half adder followed by MUXCY to
// implement ripple carry and XORCY to complete a full adder.
//
// 15 slices used.
//
module add28s(
    input [27:0] A,
    input [27:0] B,
    input CI,
    output CO,
    output [27:0] Q,
    input CLK,
	 input CE,
	 input SCLR
    );
// internal signals
wire [27:0] c;	// carry propogation
// use 28 one-bit adders
add1s a27 (.A(A[27]), .B(B[27]), .CI(c[26]), .CO(c[27]), .Q(Q[27]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a26 (.A(A[26]), .B(B[26]), .CI(c[25]), .CO(c[26]), .Q(Q[26]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a25 (.A(A[25]), .B(B[25]), .CI(c[24]), .CO(c[25]), .Q(Q[25]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a24 (.A(A[24]), .B(B[24]), .CI(c[23]), .CO(c[24]), .Q(Q[24]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a23 (.A(A[23]), .B(B[23]), .CI(c[22]), .CO(c[23]), .Q(Q[23]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a22 (.A(A[22]), .B(B[22]), .CI(c[21]), .CO(c[22]), .Q(Q[22]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a21 (.A(A[21]), .B(B[21]), .CI(c[20]), .CO(c[21]), .Q(Q[21]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a20 (.A(A[20]), .B(B[20]), .CI(c[19]), .CO(c[20]), .Q(Q[20]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a19 (.A(A[19]), .B(B[19]), .CI(c[18]), .CO(c[19]), .Q(Q[19]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a18 (.A(A[18]), .B(B[18]), .CI(c[17]), .CO(c[18]), .Q(Q[18]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a17 (.A(A[17]), .B(B[17]), .CI(c[16]), .CO(c[17]), .Q(Q[17]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a16 (.A(A[16]), .B(B[16]), .CI(c[15]), .CO(c[16]), .Q(Q[16]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a15 (.A(A[15]), .B(B[15]), .CI(c[14]), .CO(c[15]), .Q(Q[15]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a14 (.A(A[14]), .B(B[14]), .CI(c[13]), .CO(c[14]), .Q(Q[14]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a13 (.A(A[13]), .B(B[13]), .CI(c[12]), .CO(c[13]), .Q(Q[13]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a12 (.A(A[12]), .B(B[12]), .CI(c[11]), .CO(c[12]), .Q(Q[12]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a11 (.A(A[11]), .B(B[11]), .CI(c[10]), .CO(c[11]), .Q(Q[11]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a10 (.A(A[10]), .B(B[10]), .CI(c[9]), .CO(c[10]), .Q(Q[10]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a9 (.A(A[9]), .B(B[9]), .CI(c[8]), .CO(c[9]), .Q(Q[9]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a8 (.A(A[8]), .B(B[8]), .CI(c[7]), .CO(c[8]), .Q(Q[8]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a7 (.A(A[7]), .B(B[7]), .CI(c[6]), .CO(c[7]), .Q(Q[7]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a6 (.A(A[6]), .B(B[6]), .CI(c[5]), .CO(c[6]), .Q(Q[6]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a5 (.A(A[5]), .B(B[5]), .CI(c[4]), .CO(c[5]), .Q(Q[5]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a4 (.A(A[4]), .B(B[4]), .CI(c[3]), .CO(c[4]), .Q(Q[4]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a3 (.A(A[3]), .B(B[3]), .CI(c[2]), .CO(c[3]), .Q(Q[3]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a2 (.A(A[2]), .B(B[2]), .CI(c[1]), .CO(c[2]), .Q(Q[2]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a1 (.A(A[1]), .B(B[1]), .CI(c[0]), .CO(c[1]), .Q(Q[1]), .CLK(CLK), .CE(CE), .RST(SCLR));
add1s a0 (.A(A[0]), .B(B[0]), .CI(CI), .CO(c[0]), .Q(Q[0]), .CLK(CLK), .CE(CE), .RST(SCLR));
// register carry output
FDCE ff (.D(c[27]), .C(CLK), .CE(CE), .CLR(SCLR), .Q(CO));
endmodule
