//
//						addsub10s.v - 10-bit adder/subtracter
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This implementation uses a LUT2 as a half adder followed by MUXCY to
// implement ripple carry and XORCY to complete a full adder.
//
// 5 slices used.
//
module addsub10s(
    input SUB,
    input [9:0] A,
    input [9:0] B,
    input CI,
    output CO,
    output [9:0] Q,
	 input CE,
	 input CLK,
	 input RST
    );
// internal signals
wire [8:0] c;	// carry propogation
// use 10 one-bit adders
addsub1s a9 (.SUB(SUB), .A(A[9]), .B(B[9]), .CI(c[8]), .CO(CO), .Q(Q[9]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a8 (.SUB(SUB), .A(A[8]), .B(B[8]), .CI(c[7]), .CO(c[8]), .Q(Q[8]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a7 (.SUB(SUB), .A(A[7]), .B(B[7]), .CI(c[6]), .CO(c[7]), .Q(Q[7]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a6 (.SUB(SUB), .A(A[6]), .B(B[6]), .CI(c[5]), .CO(c[6]), .Q(Q[6]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a5 (.SUB(SUB), .A(A[5]), .B(B[5]), .CI(c[4]), .CO(c[5]), .Q(Q[5]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a4 (.SUB(SUB), .A(A[4]), .B(B[4]), .CI(c[3]), .CO(c[4]), .Q(Q[4]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a3 (.SUB(SUB), .A(A[3]), .B(B[3]), .CI(c[2]), .CO(c[3]), .Q(Q[3]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a2 (.SUB(SUB), .A(A[2]), .B(B[2]), .CI(c[1]), .CO(c[2]), .Q(Q[2]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a1 (.SUB(SUB), .A(A[1]), .B(B[1]), .CI(c[0]), .CO(c[1]), .Q(Q[1]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a0 (.SUB(SUB), .A(A[0]), .B(B[0]), .CI(CI), .CO(c[0]), .Q(Q[0]), .CE(CE), .CLK(CLK), .RST(RST));
endmodule
