//
//						addsub16a.v - 16-bit adder/subtracter
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This implementation uses a LUT2 as a half adder followed by MUXCY to
// implement ripple carry and XORCY to complete a full adder.
//
// 8 slices used.
//
module addsub16a (
    input SUB,
    input [15:0] A,
    input [15:0] B,
    input CI,
    output CO,
    output [15:0] Y
    );
// internal signals
wire [14:0] c;	// carry propogation
// use 16 one-bit adders
addsub1a a15 (.SUB(SUB), .A(A[15]), .B(B[15]), .CI(c[14]), .CO(CO), .Y(Y[15]));
addsub1a a14 (.SUB(SUB), .A(A[14]), .B(B[14]), .CI(c[13]), .CO(c[14]), .Y(Y[14]));
addsub1a a13 (.SUB(SUB), .A(A[13]), .B(B[13]), .CI(c[12]), .CO(c[13]), .Y(Y[13]));
addsub1a a12 (.SUB(SUB), .A(A[12]), .B(B[12]), .CI(c[11]), .CO(c[12]), .Y(Y[12]));
addsub1a a11 (.SUB(SUB), .A(A[11]), .B(B[11]), .CI(c[10]), .CO(c[11]), .Y(Y[11]));
addsub1a a10 (.SUB(SUB), .A(A[10]), .B(B[10]), .CI(c[9]), .CO(c[10]), .Y(Y[10]));
addsub1a a9 (.SUB(SUB), .A(A[9]), .B(B[9]), .CI(c[8]), .CO(c[9]), .Y(Y[9]));
addsub1a a8 (.SUB(SUB), .A(A[8]), .B(B[8]), .CI(c[7]), .CO(c[8]), .Y(Y[8]));
addsub1a a7 (.SUB(SUB), .A(A[7]), .B(B[7]), .CI(c[6]), .CO(c[7]), .Y(Y[7]));
addsub1a a6 (.SUB(SUB), .A(A[6]), .B(B[6]), .CI(c[5]), .CO(c[6]), .Y(Y[6]));
addsub1a a5 (.SUB(SUB), .A(A[5]), .B(B[5]), .CI(c[4]), .CO(c[5]), .Y(Y[5]));
addsub1a a4 (.SUB(SUB), .A(A[4]), .B(B[4]), .CI(c[3]), .CO(c[4]), .Y(Y[4]));
addsub1a a3 (.SUB(SUB), .A(A[3]), .B(B[3]), .CI(c[2]), .CO(c[3]), .Y(Y[3]));
addsub1a a2 (.SUB(SUB), .A(A[2]), .B(B[2]), .CI(c[1]), .CO(c[2]), .Y(Y[2]));
addsub1a a1 (.SUB(SUB), .A(A[1]), .B(B[1]), .CI(c[0]), .CO(c[1]), .Y(Y[1]));
addsub1a a0 (.SUB(SUB), .A(A[0]), .B(B[0]), .CI(CI), .CO(c[0]), .Y(Y[0]));
endmodule
