//
//						addsub1a.v - 1-bit adder/subtracter
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This implementation uses a LUT3 as a half adder (XOR) followed by MUXCY to
// implement ripple carry and XORCY to complete a full adder.
//
//			I2	I1	I0	O
//		CI	SU	B	A	h	Y	CO
//		0	0	0	0	0	0	0	Y = A + B (ADD)
//		0	0	0	1	1	1	0
//		0	0	1	0	1	1	0  6
//		0	0	1	1	0	0	1
//		0	1	0	0	1	1	0	Y = A + ~B (SUB)
//		0	1	0	1	0	0	1
//		0	1	1	0	0	0	0  9
//		0	1	1	1	1	1	0
//		1	0	0	0	0	1	0	Y = A + B + C
//		1	0	0	1	1	0	1
//		1	0	1	0	1	0	1  6
//		1	0	1	1	0	1	1
//		1	1	0	0	1	0	1	Y = A + ~B + C
//		1	1	0	1	0	1	1
//		1	1	1	0	0	1	0  9
//		1	1	1	1	1	0	1
//
module addsub1a (
	 input SUB,
    input A,
    input B,
    input CI,
    output CO,
	 output Y
    );
// internal signals
wire h;	// half-adder output
// half adder
LUT3_L #(.INIT(8'h96)) ha (.I0(A), .I1(B), .I2(SUB), .LO(h));	// half-adder
MUXCY_L cp (.DI(A), .CI(CI), .S(h), .LO(CO));	// select CI if S true
XORCY fa (.CI(CI), .LI(h), .O(Y));	// XOR with carry to form full adder
endmodule
