//
//						addsub22s.v - 22-bit adder/subtracter
//
//					(C) Copyright 2004-2010 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This implementation uses a LUT2 as a half adder followed by MUXCY to
// implement ripple carry and XORCY to complete a full adder.
//
// 11 slices used.
//
// History:
//		2-12-10	modified for 22 bits
//
module addsub22s(
    input SUB,
    input [21:0] A,
    input [21:0] B,
    input CI,
    output CO,
    output [21:0] Q,
	 input CE,
	 input CLK,
	 input RST
    );
// internal signals
wire [20:0] c;	// carry propogation
// use 22 one-bit adders
addsub1s a21 (.SUB(SUB), .A(A[21]), .B(B[21]), .CI(c[20]), .CO(CO), .Q(Q[21]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a20 (.SUB(SUB), .A(A[20]), .B(B[20]), .CI(c[19]), .CO(c[20]), .Q(Q[20]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a19 (.SUB(SUB), .A(A[19]), .B(B[19]), .CI(c[18]), .CO(c[19]), .Q(Q[19]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a18 (.SUB(SUB), .A(A[18]), .B(B[18]), .CI(c[17]), .CO(c[18]), .Q(Q[18]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a17 (.SUB(SUB), .A(A[17]), .B(B[17]), .CI(c[16]), .CO(c[17]), .Q(Q[17]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a16 (.SUB(SUB), .A(A[16]), .B(B[16]), .CI(c[15]), .CO(c[16]), .Q(Q[16]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a15 (.SUB(SUB), .A(A[15]), .B(B[15]), .CI(c[14]), .CO(c[15]), .Q(Q[15]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a14 (.SUB(SUB), .A(A[14]), .B(B[14]), .CI(c[13]), .CO(c[14]), .Q(Q[14]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a13 (.SUB(SUB), .A(A[13]), .B(B[13]), .CI(c[12]), .CO(c[13]), .Q(Q[13]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a12 (.SUB(SUB), .A(A[12]), .B(B[12]), .CI(c[11]), .CO(c[12]), .Q(Q[12]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a11 (.SUB(SUB), .A(A[11]), .B(B[11]), .CI(c[10]), .CO(c[11]), .Q(Q[11]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a10 (.SUB(SUB), .A(A[10]), .B(B[10]), .CI(c[9]), .CO(c[10]), .Q(Q[10]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a9 (.SUB(SUB), .A(A[9]), .B(B[9]), .CI(c[8]), .CO(c[9]), .Q(Q[9]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a8 (.SUB(SUB), .A(A[8]), .B(B[8]), .CI(c[7]), .CO(c[8]), .Q(Q[8]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a7 (.SUB(SUB), .A(A[7]), .B(B[7]), .CI(c[6]), .CO(c[7]), .Q(Q[7]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a6 (.SUB(SUB), .A(A[6]), .B(B[6]), .CI(c[5]), .CO(c[6]), .Q(Q[6]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a5 (.SUB(SUB), .A(A[5]), .B(B[5]), .CI(c[4]), .CO(c[5]), .Q(Q[5]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a4 (.SUB(SUB), .A(A[4]), .B(B[4]), .CI(c[3]), .CO(c[4]), .Q(Q[4]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a3 (.SUB(SUB), .A(A[3]), .B(B[3]), .CI(c[2]), .CO(c[3]), .Q(Q[3]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a2 (.SUB(SUB), .A(A[2]), .B(B[2]), .CI(c[1]), .CO(c[2]), .Q(Q[2]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a1 (.SUB(SUB), .A(A[1]), .B(B[1]), .CI(c[0]), .CO(c[1]), .Q(Q[1]), .CE(CE), .CLK(CLK), .RST(RST));
addsub1s a0 (.SUB(SUB), .A(A[0]), .B(B[0]), .CI(CI), .CO(c[0]), .Q(Q[0]), .CE(CE), .CLK(CLK), .RST(RST));
endmodule
