//
//					addsubmovneg16a.v - 16-bit adder/subtracter
//
//					(C) Copyright 2004-2009 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
//	ENA SUB Desc.
//  0   0  Y = B + CI
//	 0   1  Y = ~B + CI
//	 1   0  Y = A + B + CI
//	 1   1  Y = A + ~B + CI
//
// 8 slices used.
//
module addsubmovneg16a(
    input SUB,
    input ENA,
    input [15:0] A,
    input [15:0] B,
    input CI,
    output CO,
    output [15:0] Y
    );
// internal signals
wire [14:0] c;	// carry propogation
// use 16 one-bit adders
addsubmovneg1a a15 (.SUB(SUB), .ENA(ENA), .A(A[15]), .B(B[15]), .CI(c[14]), .CO(CO), .Y(Y[15]));
addsubmovneg1a a14 (.SUB(SUB), .ENA(ENA), .A(A[14]), .B(B[14]), .CI(c[13]), .CO(c[14]), .Y(Y[14]));
addsubmovneg1a a13 (.SUB(SUB), .ENA(ENA), .A(A[13]), .B(B[13]), .CI(c[12]), .CO(c[13]), .Y(Y[13]));
addsubmovneg1a a12 (.SUB(SUB), .ENA(ENA), .A(A[12]), .B(B[12]), .CI(c[11]), .CO(c[12]), .Y(Y[12]));
addsubmovneg1a a11 (.SUB(SUB), .ENA(ENA), .A(A[11]), .B(B[11]), .CI(c[10]), .CO(c[11]), .Y(Y[11]));
addsubmovneg1a a10 (.SUB(SUB), .ENA(ENA), .A(A[10]), .B(B[10]), .CI(c[9]), .CO(c[10]), .Y(Y[10]));
addsubmovneg1a a9 (.SUB(SUB), .ENA(ENA), .A(A[9]), .B(B[9]), .CI(c[8]), .CO(c[9]), .Y(Y[9]));
addsubmovneg1a a8 (.SUB(SUB), .ENA(ENA), .A(A[8]), .B(B[8]), .CI(c[7]), .CO(c[8]), .Y(Y[8]));
addsubmovneg1a a7 (.SUB(SUB), .ENA(ENA), .A(A[7]), .B(B[7]), .CI(c[6]), .CO(c[7]), .Y(Y[7]));
addsubmovneg1a a6 (.SUB(SUB), .ENA(ENA), .A(A[6]), .B(B[6]), .CI(c[5]), .CO(c[6]), .Y(Y[6]));
addsubmovneg1a a5 (.SUB(SUB), .ENA(ENA), .A(A[5]), .B(B[5]), .CI(c[4]), .CO(c[5]), .Y(Y[5]));
addsubmovneg1a a4 (.SUB(SUB), .ENA(ENA), .A(A[4]), .B(B[4]), .CI(c[3]), .CO(c[4]), .Y(Y[4]));
addsubmovneg1a a3 (.SUB(SUB), .ENA(ENA), .A(A[3]), .B(B[3]), .CI(c[2]), .CO(c[3]), .Y(Y[3]));
addsubmovneg1a a2 (.SUB(SUB), .ENA(ENA), .A(A[2]), .B(B[2]), .CI(c[1]), .CO(c[2]), .Y(Y[2]));
addsubmovneg1a a1 (.SUB(SUB), .ENA(ENA), .A(A[1]), .B(B[1]), .CI(c[0]), .CO(c[1]), .Y(Y[1]));
addsubmovneg1a a0 (.SUB(SUB), .ENA(ENA), .A(A[0]), .B(B[0]), .CI(CI), .CO(c[0]), .Y(Y[0]));
endmodule
