//
//					 addsubmovneg1a.v - 1-bit adder-subtractor
//
//					(C) Copyright 2004-2009 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This implementation uses a LUT4 as a half adder (XOR) followed by MUXCY to
// implement ripple carry and XORCY to complete a full adder. The MULT_AND gate
// is used to zero the A input for loading and negating.
//
//			I3	I2	I1 I0	O
//		CI	SU	B	A	EA	h	Y	CO
//		0	0	0	0	0	0	0	0	MOV
//		0	0	0	0	1	0	0	0	ADD
//		0	0	0	1	0	0	0	0
//		0	0	0	1	1	1	1	0
//		0	0	1	0	0	1	1	0
//		0	0	1	0	1	1	1	0
//		0	0	1	1	0	1	1	0
//		0	0	1	1	1	0	0	1
//		0	1	0	0	0	1	1	0	CMP
//		0	1	0	0	1	1	1	0	SBB
//		0	1	0	1	0	1	1	0
//		0	1	0	1	1	0	0	1
//		0	1	1	0	0	0	0	0
//		0	1	1	0	1	0	0	0
//		0	1	1	1	0	0	0	0
//		0	1	1	1	1	1	1	0
//		1	0	0	0	0	0	1	0	MOV
//		1	0	0	0	1	0	1	0	ADC
//		1	0	0	1	0	0	1	0
//		1	0	0	1	1	1	0	1
//		1	0	1	0	0	1	0	1
//		1	0	1	0	1	1	0	1
//		1	0	1	1	0	1	0	1
//		1	0	1	1	1	0	1	1
//		1	1	0	0	0	1	0	1	NEG
//		1	1	0	0	1	1	0	1	SUB
//		1	1	0	1	0	1	0	1
//		1	1	0	1	1	0	1	1
//		1	1	1	0	0	0	1	0
//		1	1	1	0	1	0	1	0
//		1	1	1	1	0	0	1	0
//		1	1	1	1	1	1	0	1
//
// 1/2 slice used.
//
module addsubmovneg1a(
	 input SUB,
    input ENA,
	 input A,
    input B,
    input CI,
    output CO,
    output Y
    );
// internal signals
wire h;	// half-adder output
wire g;	// and gate output
// accumulator logic
LUT4_L #(.INIT(16'h8778)) ha (.I0(ENA), .I1(A), .I2(B), .I3(SUB), .LO(h));	// half-adder
MULT_AND muland (.I0(ENA), .I1(A), .LO(g));	// gate to zero adder A input
MUXCY_L cp (.DI(g), .CI(CI), .S(h), .LO(CO));	// select CI if S true
XORCY fa (.CI(CI), .LI(h), .O(Y));	// XOR with carry to form full adder
endmodule
