//
//								inc18s.v - 13-bit incrementer
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This implementation uses a LUT2 as a half adder followed by MUXCY to
// implement ripple carry and XORCY to complete a full adder.
//
// 9 slices used.
//
module inc18s(
    input [17:0] A,
    input CI,
    output CO,
    output [17:0] Q,
    input CLK,
	 input CE,
	 input SCLR
    );
// internal signals
wire [17:0] c;	// carry propogation
// use 18 one-bit incrementers
inc1s a17 (.A(A[17]), .CI(c[16]), .CO(c[17]), .Q(Q[17]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a16 (.A(A[16]), .CI(c[15]), .CO(c[16]), .Q(Q[16]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a15 (.A(A[15]), .CI(c[14]), .CO(c[15]), .Q(Q[15]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a14 (.A(A[14]), .CI(c[13]), .CO(c[14]), .Q(Q[14]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a13 (.A(A[13]), .CI(c[12]), .CO(c[13]), .Q(Q[13]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a12 (.A(A[12]), .CI(c[11]), .CO(c[12]), .Q(Q[12]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a11 (.A(A[11]), .CI(c[10]), .CO(c[11]), .Q(Q[11]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a10 (.A(A[10]), .CI(c[9]), .CO(c[10]), .Q(Q[10]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a9 (.A(A[9]), .CI(c[8]), .CO(c[9]), .Q(Q[9]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a8 (.A(A[8]), .CI(c[7]), .CO(c[8]), .Q(Q[8]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a7 (.A(A[7]), .CI(c[6]), .CO(c[7]), .Q(Q[7]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a6 (.A(A[6]), .CI(c[5]), .CO(c[6]), .Q(Q[6]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a5 (.A(A[5]), .CI(c[4]), .CO(c[5]), .Q(Q[5]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a4 (.A(A[4]), .CI(c[3]), .CO(c[4]), .Q(Q[4]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a3 (.A(A[3]), .CI(c[2]), .CO(c[3]), .Q(Q[3]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a2 (.A(A[2]), .CI(c[1]), .CO(c[2]), .Q(Q[2]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a1 (.A(A[1]), .CI(c[0]), .CO(c[1]), .Q(Q[1]), .CLK(CLK), .CE(CE), .RST(SCLR));
inc1s a0 (.A(A[0]), .CI(CI), .CO(c[0]), .Q(Q[0]), .CLK(CLK), .CE(CE), .RST(SCLR));
// register carry output
FDCE ff (.D(c[17]), .C(CLK), .CE(CE), .CLR(SCLR), .Q(CO));
endmodule
