//
//								inc1s.v - 1-bit incrementer
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This implementation uses MUXCY and XORCY to propogate a carry input.
//
module inc1s(
    input A,
    input CI,
    output CO,
    output Q,
    input CLK,
	 input CE,
	 input RST
    );
// internal signals
wire f;	// full-adder output
// propogate carry
MUXCY_L cp (.CI(CI), .DI(A), .S(A), .LO(CO));
XORCY_L fa (.CI(CI), .LI(A), .LO(f));
FDRSE ff (.D(f), .C(CLK), .CE(CE), .R(RST), .S(1'b0), .Q(Q));
endmodule
