//
//							lu1a.v - 1-bit Logic Unit
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This module combines one LUT for operations using the A and B inputs
// with another LUT for manipulation of input A using a mask at input C. 
//
// Multibit LUT:
//
//				B	A
//		I3	I2	I1	I0	O	Op.
//		0	0	0	0	1	NOT B
//		0	0	0	1	1	
//		0	0	1	0	0	3
//		0	0	1	1	0	
//		0	1	0	0	0	A AND B
//		0	1	0	1	0	
//		0	1	1	0	0	8
//		0	1	1	1	1	
//		1	0	0	0	0	A OR B
//		1	0	0	1	1	
//		1	0	1	0	1	E
//		1	0	1	1	1	
//		1	1	0	0	0	A XOR B
//		1	1	0	1	1	
//		1	1	1	0	1	6
//		1	1	1	1	0	
//
// Single bit LUT:
//
//				C	A
//		I3	I2	I1	I0	O	Op.
//		0	0	0	0	0	MASK (AND)
//		0	0	0	1	0	
//		0	0	1	0	0	8
//		0	0	1	1	1	
//		0	1	0	0	0	RESET (ANDN)
//		0	1	0	1	1	
//		0	1	1	0	0	2
//		0	1	1	1	0	
//		1	0	0	0	0	SET (OR)
//		1	0	0	1	1	
//		1	0	1	0	1	E
//		1	0	1	1	1	
//		1	1	0	0	0	INVERT (XOR)
//		1	1	0	1	1	
//		1	1	1	0	1	6
//		1	1	1	1	0	
//
// 16 slices used.
//
module lu1a (
    input A,	// register A
    input B,	// register B
    input C,	// constant C
    input [2:0] OP,	// bit 2 select single bit (1) or multibit (0) operations
    output Y	// output
    );
// use 2 LUT4s - one for multiple-bit operations and one for single bit manipulation
wire y0,y1; // outputs from 2 LUTs
LUT4_L #(.INIT(16'h6E83)) mb (.I0(A), .I1(B), .I2(OP[0]), .I3(OP[1]), .LO(y0));
LUT4_L #(.INIT(16'h6E28)) sb (.I0(A), .I1(C), .I2(OP[0]), .I3(OP[1]), .LO(y1));
MUXF5 mux (.I0(y0), .I1(y1), .S(OP[2]), .O(Y));
endmodule
