// 1024 x 18 Coefficient ROM
// (C) Copyright 2008 John B. Stephensen  All rights reserved.
module resample18vfrom (aa, ab, da, db, ce, clk, rst);
   input [9:0] aa,ab;   // address ports
   output [17:0] da,db; // data read ports
   input ce;		// clock enable
   input clk;           // common clock
   input rst;           // read port reset
// block RAM
RAMB16_S18_S18 #(
   .INIT_00(256'h0003FFFCFFF5FFEEFFE7FFE1FFDBFFD6FFD0FFCCFFC7FFC2FFBDFFBAFFB3FFBC),
   .INIT_01(256'h00DA00C700B500A400940084007500670059004C004000340029001F0015000C),
   .INIT_02(256'h02500235021B020101E701CE01B5019D0185016D01560140012A0115010100ED),
   .INIT_03(256'h03E403CE03B803A1038903710358033E0325030A02F002D502BB02A00285026A),
   .INIT_04(256'h04870489048A048904850480047904710467045B044E043F042F041E040B03F8),
   .INIT_05(256'h032903500376039903B903D703F3040C04230438044A045A04670472047B0482),
   .INIT_06(256'hFF8DFFD40018005C009F00E0011F015D019801D20209023F027202A302D202FF),
   .INIT_07(256'hFAEBFB32FB79FBC3FC0CFC57FCA2FCEEFD3AFD86FDD2FE1DFE68FEB3FEFCFF45),
   .INIT_08(256'hF7C7F7E1F7FEF81FF844F86DF899F8C8F8FBF931F969F9A4F9E1FA21FA62FAA6),
   .INIT_09(256'hF8C0F88AF859F82DF807F7E6F7CAF7B3F7A2F796F78FF78CF78FF796F7A2F7B3),
   .INIT_0A(256'hFEC4FE43FDC7FD4EFCD9FC67FBFBFB92FB2EFACFFA75FA1FF9CFF983F93DF8FC),
   .INIT_0B(256'h07BE072D069A0607057304DE044A03B60322029001FE016F00E10055FFCDFF47),
   .INIT_0C(256'h0EE40E9B0E4A0DF30D960D330CC90C5B0BE70B6E0AF10A7109EC096508DA084D),
   .INIT_0D(256'h0EEC0F330F700FA20FCB0FEA1000100B100E10070FF70FDE0FBC0F920F600F26),
   .INIT_0E(256'h056D0646071707E008A2095B0A0B0AB30B520BE70C730CF50D6D0DDC0E410E9B),
   .INIT_0F(256'hF56BF679F788F897F9A6FAB4FBC0FCCAFDD2FED6FFD600D201C902BB03A7048E),
   .INIT_10(256'hE71AE7C1E873E930E9F7EAC7EBA0EC81ED69EE58EF4EF049F148F24CF354F45E),
   .INIT_11(256'hE437E3EBE3B1E388E370E36AE374E38EE3B8E3F2E43CE494E4FAE56FE5F0E67F),
   .INIT_12(256'hF22CF0D3EF88EE4CED20EC03EAF7E9FCE912E839E771E6BBE617E584E503E494),
   .INIT_13(256'h0D510B72099407B905E1040F0241007AFEBCFD04FB56F9B2F819F68BF509F394),
   .INIT_14(256'h2877271A25AC242E22A321091F641DB41BFA1A37186C169C14C612EC110F0F30),
   .INIT_15(256'h324D327A3289327B324F320731A33124308B2FD82F0D2E2A2D302C202AFB29C3),
   .INIT_16(256'h1ED920F722F924DD26A2284929D02B382C812DA92EB22F9B3064310D31973202),
   .INIT_17(256'hF06CF3D1F72DFA7EFDC100F4041707290A280D120FE612A3154817D41A461C9D),
   .INIT_18(256'hBAC5BDC4C0D9C401C73CCA86CDDED141D4AED821DB9ADF16E293E60FE989ECFD),
   .INIT_19(256'h9D529DD69E8F9F7CA09CA1ECA36CA518A6EFA8F0AB17AD64AFD3B264B513B7DF),
   .INIT_1A(256'hB5D1B257AF22AC32A986A71EA4F9A318A179A01A9EFD9E1E9D7E9D1B9CF49D07),
   .INIT_1B(256'h1116098A0238FB22F446EDA9E749E12ADB4CD5AFD056CB3FC66DC1DEBD95B991),
   .INIT_1C(256'hA17797858DA583DB7A2A7093671C5DC554914B84429F39E5315828FB20D018D8),
   .INIT_1D(256'h4078370C2D7F23D51A1010340644FC44F237E81FDE01D3E0C9BEBFA0B588AB79),
   .INIT_1E(256'hBC22B654B039A9D2A3249C2E94F58D7B85C17DCC759D6D3864A05BD752E149C0),
   .INIT_1F(256'hEABFEA8FE9FFE90FE7BFE611E404E19ADED3DBB0D833D45CD02DCBA8C6CDC1A0),
   .INIT_20(256'hBC22C1A0C6CDCBA8D02DD45CD833DBB0DED3E19AE404E611E7BFE90FE9FFEA8F),
   .INIT_21(256'h407849C052E15BD764A06D38759D7DCC85C18D7B94F59C2EA324A9D2B039B654),
   .INIT_22(256'hA177AB79B588BFA0C9BED3E0DE01E81FF237FC44064410341A1023D52D7F370C),
   .INIT_23(256'h111618D820D028FB315839E5429F4B8454915DC5671C70937A2A83DB8DA59785),
   .INIT_24(256'hB5D1B991BD95C1DEC66DCB3FD056D5AFDB4CE12AE749EDA9F446FB220238098A),
   .INIT_25(256'h9D529D079CF49D1B9D7E9E1E9EFDA01AA179A318A4F9A71EA986AC32AF22B257),
   .INIT_26(256'hBAC5B7DFB513B264AFD3AD64AB17A8F0A6EFA518A36CA1ECA09C9F7C9E8F9DD6),
   .INIT_27(256'hF06CECFDE989E60FE293DF16DB9AD821D4AED141CDDECA86C73CC401C0D9BDC4),
   .INIT_28(256'h1ED91C9D1A4617D4154812A30FE60D120A280729041700F4FDC1FA7EF72DF3D1),
   .INIT_29(256'h324D32023197310D30642F9B2EB22DA92C812B3829D0284926A224DD22F920F7),
   .INIT_2A(256'h287729C32AFB2C202D302E2A2F0D2FD8308B312431A33207324F327B3289327A),
   .INIT_2B(256'h0D510F30110F12EC14C6169C186C1A371BFA1DB41F64210922A3242E25AC271A),
   .INIT_2C(256'hF22CF394F509F68BF819F9B2FB56FD04FEBC007A0241040F05E107B909940B72),
   .INIT_2D(256'hE437E494E503E584E617E6BBE771E839E912E9FCEAF7EC03ED20EE4CEF88F0D3),
   .INIT_2E(256'hE71AE67FE5F0E56FE4FAE494E43CE3F2E3B8E38EE374E36AE370E388E3B1E3EB),
   .INIT_2F(256'hF56BF45EF354F24CF148F049EF4EEE58ED69EC81EBA0EAC7E9F7E930E873E7C1),
   .INIT_30(256'h056D048E03A702BB01C900D2FFD6FED6FDD2FCCAFBC0FAB4F9A6F897F788F679),
   .INIT_31(256'h0EEC0E9B0E410DDC0D6D0CF50C730BE70B520AB30A0B095B08A207E007170646),
   .INIT_32(256'h0EE40F260F600F920FBC0FDE0FF71007100E100B10000FEA0FCB0FA20F700F33),
   .INIT_33(256'h07BE084D08DA096509EC0A710AF10B6E0BE70C5B0CC90D330D960DF30E4A0E9B),
   .INIT_34(256'hFEC4FF47FFCD005500E1016F01FE0290032203B6044A04DE05730607069A072D),
   .INIT_35(256'hF8C0F8FCF93DF983F9CFFA1FFA75FACFFB2EFB92FBFBFC67FCD9FD4EFDC7FE43),
   .INIT_36(256'hF7C7F7B3F7A2F796F78FF78CF78FF796F7A2F7B3F7CAF7E6F807F82DF859F88A),
   .INIT_37(256'hFAEBFAA6FA62FA21F9E1F9A4F969F931F8FBF8C8F899F86DF844F81FF7FEF7E1),
   .INIT_38(256'hFF8DFF45FEFCFEB3FE68FE1DFDD2FD86FD3AFCEEFCA2FC57FC0CFBC3FB79FB32),
   .INIT_39(256'h032902FF02D202A30272023F020901D20198015D011F00E0009F005C0018FFD4),
   .INIT_3A(256'h04870482047B04720467045A044A04380423040C03F303D703B9039903760350),
   .INIT_3B(256'h03E403F8040B041E042F043F044E045B046704710479048004850489048A0489),
   .INIT_3C(256'h0250026A028502A002BB02D502F0030A0325033E03580371038903A103B803CE),
   .INIT_3D(256'h00DA00ED01010115012A01400156016D0185019D01B501CE01E70201021B0235),
   .INIT_3E(256'h0003000C0015001F002900340040004C0059006700750084009400A400B500C7),
   .INIT_3F(256'h0000FFBCFFB3FFBAFFBDFFC2FFC7FFCCFFD0FFD6FFDBFFE1FFE7FFEEFFF5FFFC),
   .INITP_00(256'hFFFFFFFFF000000000000000000000000000000000000000000000003FFFFFFF),
   .INITP_01(256'hFFFFFC000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFF),
   .INITP_02(256'hFFC000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF),
   .INITP_03(256'h5555555555555555555400000000000003FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF),
   .INITP_04(256'hFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000005555555555555555555),
   .INITP_05(256'hFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000000FF),
   .INITP_06(256'hFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000000000000FFFFF),
   .INITP_07(256'h3FFFFFFF000000000000000000000000000000000000000000000003FFFFFFFF)
   ) rom0 (
   .ADDRA(aa),
   .DIA(16'hFFFF),
   .DIPA(2'b11),
   .DOA(da[15:0]),
   .DOPA(da[17:16]),
   .CLKA(clk),
   .WEA(1'b0),
   .ENA(ce),
   .SSRA(rst),
   .ADDRB(ab),
   .DIB(16'hFFFF),
   .DIPB(2'b11),
   .DOB(db[15:0]),
   .DOPB(db[17:16]),
   .CLKB(clk),
   .WEB(1'b0),
   .ENB(ce),
   .SSRB(rst)
   );
endmodule
