//
//								shift22x16.v - 22-bit Shifter
//
//					  (C) Copyright 2007-2010 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// Shift 22-bit signed integer right by 0-15 bits. 44 slices.
//
// History:
//	2-12-10	Modified for 22 bits.
//
module shift22x16(
    input [21:0] D,
    output [21:0] Y,
    input [3:0] S
    );
// internal signals
wire [21:0] i;
// shift by 1
MUX4X22 mux1 (
	.D0(D),
	.D1({D[21],D[21:1]}),					// shift 1
	.D2({D[21],D[21],D[21:2]}),			// shift 2
	.D3({D[21],D[21],D[21],D[21:3]}),	// shift 3
	.S(S[1:0]),
	.Y(i)
	);
// shift by 4
MUX4X22 mux4 (
	.D0(i),
	.D1({i[21],i[21],i[21],i[21],i[21:4]}),																	// shift 4
	.D2({i[21],i[21],i[21],i[21],i[21],i[21],i[21],i[21],i[21:8]}),									// shift 8
	.D3({i[21],i[21],i[21],i[21],i[21],i[21],i[21],i[21],i[21],i[21],i[21],i[21],i[21:12]}),	// shift 12
	.S(S[3:2]),
	.Y(Y)
	);
endmodule
