//
//						tc16a.v - 16-bit true/complement logic
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// 8 slices used.
//
module tc16a (
    input [15:0] D,
    input CMP,
    output [15:0] Y
    );
// internal signals
wire [14:0] c;	// carry propogation
// use 8 one-bit true/complement element with ripple carry
tc1a a15 (.D(D[15]), .C(CMP), .CI(c[14]), .CO(), .Y(Y[15]));
tc1a a14 (.D(D[14]), .C(CMP), .CI(c[13]), .CO(c[14]), .Y(Y[14]));
tc1a a13 (.D(D[13]), .C(CMP), .CI(c[12]), .CO(c[13]), .Y(Y[13]));
tc1a a12 (.D(D[12]), .C(CMP), .CI(c[11]), .CO(c[12]), .Y(Y[12]));
tc1a a11 (.D(D[11]), .C(CMP), .CI(c[10]), .CO(c[11]), .Y(Y[11]));
tc1a a10 (.D(D[10]), .C(CMP), .CI(c[9]), .CO(c[10]), .Y(Y[10]));
tc1a a9 (.D(D[9]), .C(CMP), .CI(c[8]), .CO(c[9]), .Y(Y[9]));
tc1a a8 (.D(D[8]), .C(CMP), .CI(c[7]), .CO(c[8]), .Y(Y[8]));
tc1a a7 (.D(D[7]), .C(CMP), .CI(c[6]), .CO(c[7]), .Y(Y[7]));
tc1a a6 (.D(D[6]), .C(CMP), .CI(c[5]), .CO(c[6]), .Y(Y[6]));
tc1a a5 (.D(D[5]), .C(CMP), .CI(c[4]), .CO(c[5]), .Y(Y[5]));
tc1a a4 (.D(D[4]), .C(CMP), .CI(c[3]), .CO(c[4]), .Y(Y[4]));
tc1a a3 (.D(D[3]), .C(CMP), .CI(c[2]), .CO(c[3]), .Y(Y[3]));
tc1a a2 (.D(D[2]), .C(CMP), .CI(c[1]), .CO(c[2]), .Y(Y[2]));
tc1a a1 (.D(D[1]), .C(CMP), .CI(c[0]), .CO(c[1]), .Y(Y[1]));
tc1a a0 (.D(D[0]), .C(CMP), .CI(CMP), .CO(c[0]), .Y(Y[0]));
endmodule
