//
//					tc1s.v - 1-bit true/complement logic element
//
//					(C) Copyright 2007-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This implementation uses a LUT2 as a half adder (XOR) followed by MUXCY to
// implement ripple carry and XORCY to complete a full adder. The output can
// also be set to zero or one.
//
//		C	D
//		I1	I0	O
//		0	0	0	true
//		0	1	1
//		1	0	1	comp
//		1	1	0
//
// The carry input is 1 for a complement operation and 0 otherwise. The
// carry input may also reflect the carry output from a previous operation.
// The increment or decrement may be disabled by inverting the carry input.
//
module tc1s (
    input D,	// data input
	 input C,	// 1 = complement input, 0 = true input
    input CI,	// carry input
    output CO,	// carry output
    output Q,	// data output
    input CLK,	// master clock
	 input CE,	// clock enable
	 input RST	// reset flip-flop
    );
// internal signals
wire h;	// half-adder output
wire f;	// full-adder output
// true/complement logic
LUT2_L #(.INIT(4'h6)) ha (.I0(D), .I1(C), .LO(h));
// carry logic - selects CI when S = 1
MUXCY_L cp (.CI(CI), .DI(1'b0), .S(h), .LO(CO));
// second half-adder
XORCY_L fa (.CI(CI), .LI(h), .LO(f));
FDRSE ff (.D(f), .C(CLK), .CE(CE), .R(RST), .S(1'b0), .Q(Q));
endmodule
