//
//						tc8s.v - 8-bit true/complement logic
//
//					(C) Copyright 2004-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// 4 slices used.
//
module tc8s (
    input [7:0] D,
    input CMP,
    output [7:0] Q,
    input CLK,
	 input CE,
	 input SCLR
    );
// internal signals
wire [6:0] c;	// carry propogation
// use 8 one-bit true/complement element with ripple carry
tc1s a7 (.D(D[7]), .C(CMP), .CI(c[6]), .CO(), .Q(Q[7]), .CLK(CLK), .CE(CE), .RST(SCLR));
tc1s a6 (.D(D[6]), .C(CMP), .CI(c[5]), .CO(c[6]), .Q(Q[6]), .CLK(CLK), .CE(CE), .RST(SCLR));
tc1s a5 (.D(D[5]), .C(CMP), .CI(c[4]), .CO(c[5]), .Q(Q[5]), .CLK(CLK), .CE(CE), .RST(SCLR));
tc1s a4 (.D(D[4]), .C(CMP), .CI(c[3]), .CO(c[4]), .Q(Q[4]), .CLK(CLK), .CE(CE), .RST(SCLR));
tc1s a3 (.D(D[3]), .C(CMP), .CI(c[2]), .CO(c[3]), .Q(Q[3]), .CLK(CLK), .CE(CE), .RST(SCLR));
tc1s a2 (.D(D[2]), .C(CMP), .CI(c[1]), .CO(c[2]), .Q(Q[2]), .CLK(CLK), .CE(CE), .RST(SCLR));
tc1s a1 (.D(D[1]), .C(CMP), .CI(c[0]), .CO(c[1]), .Q(Q[1]), .CLK(CLK), .CE(CE), .RST(SCLR));
tc1s a0 (.D(D[0]), .C(CMP), .CI(CMP), .CO(c[0]), .Q(Q[0]), .CLK(CLK), .CE(CE), .RST(SCLR));
endmodule
