//
//					zero16.v - 16-bit Fast Zero Detection Logic
//
//					(C) Copyright 2007-2008 John B. Stephensen
//
// This Verilog source file and all its derivatives are licensed only for
// personal non-profit educational use in the Amateur Radio Service and
// the license is not transferrable. The information is provided as-is for
// experimental purposes and the author does not warranty its freedom
// from defects or its suitability for any specific application.
//
// This implementation uses carry multiplexers to detect a value of zero on the inpuut.
//
module zero16(
	 input [15:0] A,
    output Y
    );
// internal signals
wire [15:0] b;	// inverted input
wire [14:0] c;	// ripple carry
// Use LUTs as inverters
LUT1_L #(.INIT(2'b01)) inv0 (.I0(A[0]), .LO(b[0]));
LUT1_L #(.INIT(2'b01)) inv1 (.I0(A[1]), .LO(b[1]));
LUT1_L #(.INIT(2'b01)) inv2 (.I0(A[2]), .LO(b[2]));
LUT1_L #(.INIT(2'b01)) inv3 (.I0(A[3]), .LO(b[3]));
LUT1_L #(.INIT(2'b01)) inv4 (.I0(A[4]), .LO(b[4]));
LUT1_L #(.INIT(2'b01)) inv5 (.I0(A[5]), .LO(b[5]));
LUT1_L #(.INIT(2'b01)) inv6 (.I0(A[6]), .LO(b[6]));
LUT1_L #(.INIT(2'b01)) inv7 (.I0(A[7]), .LO(b[7]));
LUT1_L #(.INIT(2'b01)) inv8 (.I0(A[8]), .LO(b[8]));
LUT1_L #(.INIT(2'b01)) inv9 (.I0(A[9]), .LO(b[9]));
LUT1_L #(.INIT(2'b01)) inv10 (.I0(A[10]), .LO(b[10]));
LUT1_L #(.INIT(2'b01)) inv11 (.I0(A[11]), .LO(b[11]));
LUT1_L #(.INIT(2'b01)) inv12 (.I0(A[12]), .LO(b[12]));
LUT1_L #(.INIT(2'b01)) inv13 (.I0(A[13]), .LO(b[13]));
LUT1_L #(.INIT(2'b01)) inv14 (.I0(A[14]), .LO(b[14]));
LUT1_L #(.INIT(2'b01)) inv15 (.I0(A[15]), .LO(b[15]));
// carry logic - selects CI when S = 1
MUXCY_L cp0 (.DI(1'b0), .CI(1'b1), .S(b[0]), .LO(c[0]));
MUXCY_L cp1 (.DI(1'b0), .CI(c[0]), .S(b[1]), .LO(c[1]));
MUXCY_L cp2 (.DI(1'b0), .CI(c[1]), .S(b[2]), .LO(c[2]));
MUXCY_L cp3 (.DI(1'b0), .CI(c[2]), .S(b[3]), .LO(c[3]));
MUXCY_L cp4 (.DI(1'b0), .CI(c[3]), .S(b[4]), .LO(c[4]));
MUXCY_L cp5 (.DI(1'b0), .CI(c[4]), .S(b[5]), .LO(c[5]));
MUXCY_L cp6 (.DI(1'b0), .CI(c[5]), .S(b[6]), .LO(c[6]));
MUXCY_L cp7 (.DI(1'b0), .CI(c[6]), .S(b[7]), .LO(c[7]));
MUXCY_L cp8 (.DI(1'b0), .CI(c[7]), .S(b[8]), .LO(c[8]));
MUXCY_L cp9 (.DI(1'b0), .CI(c[8]), .S(b[9]), .LO(c[9]));
MUXCY_L cp10 (.DI(1'b0), .CI(c[9]), .S(b[10]), .LO(c[10]));
MUXCY_L cp11 (.DI(1'b0), .CI(c[10]), .S(b[11]), .LO(c[11]));
MUXCY_L cp12 (.DI(1'b0), .CI(c[11]), .S(b[12]), .LO(c[12]));
MUXCY_L cp13 (.DI(1'b0), .CI(c[12]), .S(b[13]), .LO(c[13]));
MUXCY_L cp14 (.DI(1'b0), .CI(c[13]), .S(b[14]), .LO(c[14]));
MUXCY_L cp15 (.DI(1'b0), .CI(c[14]), .S(b[15]), .LO(Y));
endmodule
