/* ARCNET trace routines
 * Copyright 1990 Russ Nelson
 */

#ifdef MSDOS
#include "global.h"
#ifdef ARCNET
#include "mbuf.h"
#include "arcnet.h"
#include "trace.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: arcdump.c,v 1.9 1996/12/23 20:37:36 root Exp root $";
#endif

void
arc_dump (fp, bpp, check)
FILE *fp;
struct mbuf **bpp;
int check;	/* Not used */
{
struct arc ahdr;
char s[20],d[20];

	(void) ntoharc (&ahdr,bpp);
	(void) parc (s, ahdr.source);
	(void) parc (d, ahdr.dest);
	traceprintf (fp, "Arcnet: len %u %s->%s", ARCLEN + len_p(*bpp), s, d);

	switch (uchar(ahdr.type))	{
		case ARC_IP:
			traceprintf (fp," type IP\n");
			ip_dump (fp, bpp, 1);
			break;
		case ARC_ARP:
			traceprintf (fp, " type ARP\n");
			arp_dump (fp, bpp);
			break;
		default:
			traceprintf (fp, " type 0x%x\n", ahdr.type);
			break;
	}
}


int
arc_forus (iface, bp)
struct iface *iface;
struct mbuf *bp;
{
	return 1;
}

#endif /* ARCNET */
#endif /* MSDOS */
