#!/bin/sh

rm -f make.inc
touch make.inc

export USEELF=0
export MAKEELF=0

echo ""
echo Since this is your first compile, a few things will need to be researched
echo in order to build you a default 'make.inc' file.
echo ""
echo You are encouraged to read the Makefile, and add to or change these
echo settings in the 'make.inc' file, but are DISCOURAGED from changing
echo the Makefile directly!
echo ""
echo ""

# First, a check for a ELF/AOUT capable system.....

if [ -e /usr/i[3456]86-linuxaout ]
then
	export USEELF=1
fi


# Next see if the compiler can handle ELF.....
if (whence gcc >/dev/null 2>&1)
then
	if (whence gcc | grep ELF >/dev/null)
	then
		export MAKEELF=1
	fi
else
	echo "Couldn't find the 'whence' command, so looking for gcc in /usr/bin"
	if (file /usr/bin/gcc | grep ELF >/dev/null)
	then
		export MAKEELF=1
	fi
fi



# Now that we have made an initial LOOK at the system, lets see if reality
# agrees with our quick look.....

# First we will create a 'Hello World' C program, and try compiling it
# in different ways.....

rm -f hw.c

echo "#include <stdio.h>" >hw.c
echo "void main (void) {" >>hw.c
echo "printf (\"Hello World!\n\");" >>hw.c
echo "}" >>hw.c

echo Testing compiler options....
if cc hw.c -o hw 2>/dev/null;
then
	echo Standard compiler options work
	if [ ${USEELF} = 1 ]
	then
		echo Your system LOOKS like it is set up for AOUT/ELF compiling
		echo but we will not use AOUT-specific flags....
		export USEELF=0
	fi
elif cc -b i486-linuxaout hw.c -o hw  2>/dev/null;
then
	echo You seem to have an ELF compiler, using aout format
	if [ ${MAKEELF} = 1 ]
	then
		echo Resetting MAKEELF compiler options appropriately
		export MAKEELF=0
	fi
else
	echo WARNING!!! Cannot determine the compiler options automatically.
	echo You will need to manually edit the make.inc file, and set
	echo the 'CC' line for your compiler.
fi

rm -f hw.c hw


# Setup the CC variable.....
echo ""
echo Setting proper CC variable based on: USEELF=${USEELF} and MAKEELF=${MAKEELF}
if [ ${USEELF} = 1 ]
then
	echo Seems to be an ELF/AOUT capable system - setting USEELF = 1
	echo USEELF = 1 >>make.inc
	if [ ${MAKEELF} != 1 ]
	then 
		echo CC = gcc -b i486-linuxaout >>make.inc
	else
		echo Seems that an ELF version of GCC found - setting to use ELF compiles "MAKEELF = 1"
		echo MAKEELF = 1 >>make.inc
		echo CC = gcc -DMAKEELF >>make.inc
	fi
else
	if [ ${MAKEELF} = 1 ]
	then 
		echo MAKEELF = 1 >>make.inc
		echo CC = gcc -DMAKEELF >>make.inc
	else
		echo CC = gcc >>make.inc
	fi
fi


# Setup the TCL variable
if [ -e /usr/local/bin/tclsh ] ; then
	echo Setting TCL = /usr/local/bin/tclsh
	echo TCL = /usr/local/bin/tclsh >>make.inc
elif [ -e /usr/bin/tclsh ] ; then
	echo Setting TCL = /usr/bin/tclsh
	echo TCL = /usr/bin/tclsh >>make.inc
elif [ -e /usr/contrib/bin/tclsh ] ; then
	echo Setting TCL = /usr/contrib/bin/tclsh
	echo TCL = /usr/contrib/bin/tclsh >>make.inc
else
	echo Cannot determine path for tclsh! This IS a problem!!!
fi


# Check for ncurses directory....
if [ ! -e /usr/include/ncurses -a ! -e /usr/local/include/ncurses.h -a ! -e /usr/include/ncurses.h ]
then
	echo "You either do not have NCURSES installed or have a recent version"
	echo "(it's hard to tell the difference)..."
	echo ""
	echo ICURSES = >>make.inc
	echo LCURSES = >>make.inc
	if [ ! -e /usr/include/curses.h ]
	then
		echo "Since a curses.h file was found, we'll assume a recent ncurses version"
		echo "and create a symlink to satisfy TNOS..."
		ln -s /usr/include/curses.h /usr/include/ncurses.h
	else
		echo Sorry, but NO version of NCURSES was found! This WILL need help!
	fi
else
	echo The ncurses files were found where they were expected....
fi


# Check if we can define OPTIONAL....
export GCCVERSION=`gcc --version`

case $GCCVERSION in
	2.7.* )
		echo GCC 2.7.0 or greater found - Setting OPTIONAL to eliminate warnings
		echo 'OPTIONAL = "-DOPTIONAL=__attribute__ ((unused))"' >>make.inc ;;
	2.6.* ) ;;
	2.5.* ) ;;
	* )
		echo There may be a problem with GCC as the version returned was "${GCCVERSION}"
esac


# Now set the OSTYPE to the proper value
export OSTYPE=`uname`
case $OSTYPE in
	BSD/OS )
		# Now, modify the PATCHES and SETSTACK to use the needed flags
		echo "PATCHES := \$(PATCHES) -DUSE_SETSTACK -DBSD_RANDOM -DBSD" >>make.inc
		echo "SETSTACK = setsp.o" >>make.inc
		export OSTYPE=BSDI ;;
	* ) ;;
esac
echo Setting OSTYPE = ${OSTYPE}
echo ""
echo OSTYPE = ${OSTYPE} >>make.inc


# Check for MSQL, and if not found, disable the appropriate flags
if [ ! -d /usr/local/Minerva/lib ]
then
	echo The MSQL package was NOT found, so it is being disabled....
	echo "*** You will want to say 'NO' when prompted for 'SQL Server support'"
	echo "*** in the configuration program...."
	echo LSQL = >>make.inc
	echo ISQL = >>make.inc
else
	echo The MSQL package WAS found, so it is being left enabled....
	echo "*** You will want to say 'YES' when prompted for 'SQL Server support'"
	echo "*** in the configuration program...."
fi


# Check the directory for installation....
export NOSDIR=/nos
export response=n
echo The default directory to install TNOS in is /nos.
echo ""
echo 'Do you wish to change this? (n/y)'
read response
if [ ${response} = "y" ]
then
	echo ""
	echo Enter new path for installation:
	read NOSDIR
	echo Setting NOSDIR = ${NOSDIR}
	echo NOSDIR = ${NOSDIR} >>make.inc
fi



# Disable automatic c2man MAN page generation
echo C2MAN_AUTO = true >>make.inc


# All done, tell the user, and exit non-zero, to make the initial 'make' fail.
# This will force the user to restart, now reading the 'make.inc' file created.
echo ""
echo This is the best that can be done, for now, hopefully it is all that
echo is needed!
echo ""
echo You will need to re-execute your make command for these setting to take
echo "effect. Exiting Makefile (with Error 1) to force you to start again ;-)...."

exit 1
