#include "global.h"
#include "files.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: catalog.c,v 1.12 1997/06/28 16:46:13 root Exp root $";
#endif

#ifdef CATALOG
char * catalog (int base, int theindex);
int catalog_check (void);
extern unsigned long filelength (int);

static FILE *strfp = NULLFILE;

char *
catalog (base, theindex)
int base, theindex;
{
static char stringbuf[256];
long seekto;

	stringbuf[0] = 0;
	if (!strfp)	{
		if ((strfp = fopen (CATALOGfile, READ_BINARY)) == NULLFILE)	{
			(void) fprintf (stderr, "\n\r\n\007Can't open catalog file '%s'!\n", CATALOGfile);
			(void) fflush (stderr);
			kpause (10000);
			where_outta_here (0, "catalog");
		}
	}

	seekto = base + theindex;
	seekto *= 256;
	fseek (strfp, seekto, SEEK_SET);
	(void) fread (stringbuf, 1, 256, strfp);
	return (stringbuf);
}

int
catalog_check (void)
{
char *vers, *cp;

	vers = catalog (0, 0);
	cp = strstr (&vers[1], "TNOS");
	if (!cp || (filelength(fileno(strfp)) % 256L) != 0L)
		return -1;
	cp += 5;
	if (strncmp (VERSION, cp, strlen(VERSION)))
		return 1;
	else
		return 0;
}

#endif
