#ifndef	_ENET_H
#define _ENET_H

/* Generic Ethernet constants and templates */
#ifndef	_GLOBAL_H
#include "global.h"
#endif

#ifndef	_MBUF_H
#include "mbuf.h"
#endif

#ifndef	_IFACE_H
#include "iface.h"
#endif

#define	EADDR_LEN	6
/* Format of an Ethernet header */
struct ether {
	uint8 dest[EADDR_LEN];
	uint8 source[EADDR_LEN];
	uint type;
};
#define	ETHERLEN	14

/* Ethernet broadcast address */
extern unsigned char Ether_bdcst[];

/* Ethernet type fields */
#define	IP_TYPE		0x800	/* Type field for IP */
#define	ARP_TYPE	0x806	/* Type field for ARP */
#define	REVARP_TYPE	0x8035	/* Type field for reverse ARP */

#define	RUNT		60	/* smallest legal size packet, no fcs */
#define	GIANT		1514	/* largest legal size packet, no fcs */

#define	MAXTRIES	16	/* Maximum number of transmission attempts */

/* In file enet.c: */
char *pether(char *out,char *addr);
int gether(char *out,const char *cp);
int enet_send(struct mbuf *bpp,struct iface *iface,uint32 gateway,int prec,int del,int tput,int rel);
int enet_output(struct iface *iface,const char *dest,char *source,int16 type,
	struct mbuf *data);
void eproc(struct iface *iface,struct mbuf *bp);

/* In enethdr.c: */
int ntohether(struct ether *ether,struct mbuf **bpp);

#endif	/* _ENET_H */
