/* Ethernet header tracing routines
 * Copyright 1991 Phil Karn, KA9Q
 */
#include "global.h"
#ifdef PACKET
#include "mbuf.h"
#include "enet.h"
#include "trace.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: enetdump.c,v 1.10 1996/12/23 20:37:36 root Exp root $";
#endif

void
ether_dump(fp,bpp,check)
FILE *fp;
struct mbuf **bpp;
int check;	/* Not used */
{
	struct ether ehdr;
	char s[20],d[20];

	(void) ntohether(&ehdr,bpp);
	(void) pether(s,(char *) ehdr.source);
	(void) pether(d,(char *) ehdr.dest);
	traceprintf(fp,"Ether: len %u %s->%s",ETHERLEN + len_p(*bpp),s,d);

	switch(ehdr.type){
		case IP_TYPE:
			traceprintf(fp," type IP\n");
			ip_dump(fp,bpp,1);
			break;
		case REVARP_TYPE:
			traceprintf(fp," type REVARP\n");
			arp_dump(fp,bpp);
			break;
		case ARP_TYPE:
			traceprintf(fp," type ARP\n");
			arp_dump(fp,bpp);
			break;
		default:
			traceprintf(fp," type 0x%x\n",ehdr.type);
			break;
	}
}
int
ether_forus(iface,bp)
struct iface *iface;
struct mbuf *bp;
{
	/* Just look at the multicast bit */

	if(bp->data[0] & 1)
		return 0;
	else
		return 1;
}

#endif
