/* PBBS Export file client
 * Copyright 1995 Brian A. Lantz, KO4KS
 */
#include "global.h"
#ifdef BBSEXPORT
#include "commands.h"
#include "mbuf.h"
#include "socket.h"
#include "session.h"
#include "netuser.h"
#include "mailbox.h"
#include "files.h"
#include "smtp.h"


#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: export.c,v 1.11 1996/12/23 20:37:36 root Exp root $";
#endif

static void exporttick (void *p);

static struct timer exporttimer;
#define MSPMINUTE (1000L*60L)


int
doexport(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	if(argc < 2){
		tprintf("export timer: %lu/%lu minutes\n",
			read_timer(&exporttimer)/MSPMINUTE,
			dur_timer(&exporttimer)/MSPMINUTE);
		return 0;
	}
	if(*argv[1] == 'n') {
		exporttick(NULL);
		return 0;
	}
	stop_timer (&exporttimer);	/* just in case */
	exporttimer.func = (void (*)(void *))exporttick;/* what to call on timeout */
	exporttimer.arg = NULL;		/* dummy value */
	set_timer(&exporttimer,atol(argv[1])*MSPMINUTE); /* set timer duration */
	start_timer(&exporttimer);     /* fire it up */
	return 0;
}

static void
exporttick(p)
void *p OPTIONAL;
{
char tempname[512], tempname2[512];
time_t t;
struct tm *tp;

	sprintf (tempname, "%s/export.exp", EXPORTDir);
	if (!access (tempname, 0))	{
		t = time ((time_t *)0);
		tp = localtime (&t);
		sprintf (tempname2, "%s/%02d%02d%02d%02d.exp", EXPORTDir,
			tp->tm_mon + 1, tp->tm_mday, tp->tm_hour, tp->tm_min);
		(void) rename (tempname, tempname2);
	}
	start_timer(&exporttimer);
}

#endif /* BBSEXPORT */
