#ifndef	_UNIX_H
#define	_UNIX_H
#define _HARDWARE_H

/*
 * Making a very PC-hardware-oriented program work under Unix is, to say the
 * least, interesting.
 */

#ifndef	_GLOBAL_H
#include "global.h"
#endif

#ifndef _CTYPE_H
#include "ctype.h"
#endif

#ifndef _TIME_H
#include <time.h>
#endif


struct screen {
    struct sessmgr_sw *sessmgr;	/* session manager */
    int flags;			/* per-session flags */
#define SMS_ACTIVE	0x01	/*   session can do output */
#define SMS_DISCARD	0x02	/*   if not active, don't block; discard */
#define SMS_NOFLOW	0x04	/*   don't do flow control */
#define SMS_SPLIT	0x08	/*   wants to be split, if possible */
    void *sesmdat;		/* per-session data for session manager */
    char *next_sm;		/* session manager for new sessions */
    char *use_sm;		/* session manager override for "create" */
	unsigned char attr;
	unsigned char statline;
};
#define	NULLSCREEN	(struct screen *)0

/* from unix.c */
extern void register_io (int fd, void *event);
extern void unregister_io (int fd);
extern unsigned long filelength (int fd);
#ifdef NEED_STRCASECMP
extern int strcasecmp (char *s1, char *s2);
#endif
#ifdef NEED_STRNCASECMP
extern int strcasecmp (char *s1, char *s2);
#endif
extern void init_sys (int);
extern void deinit_sys (void);
extern void giveup (void);
#ifndef _GLOBAL_H
#ifdef J_FREE_HACK
extern void j_free (void *);
#else
extern void j_free (const void *);
#endif
#endif

/* from unixxasy.c */
extern int doasyconfig (int, char **, void *);

/* from sessmgr.c */
extern void ioinit (int);
extern void iostop (void);
extern void iosuspend (void);
extern void ioresume (void);
extern void swapscreen (struct session *old, struct session *new);
extern void putch (int c);
extern void cputs (const char *);
extern void clreol (void);
#ifndef _GLOBAL_H
extern void rflush (void);
#endif
extern void j_newscreen (struct session *);
extern void freescreen (struct session *);
extern void clrscr (void);
extern int wherex (void);
extern int wherey (void);
extern void window (int, int, int, int);
extern void gotoxy (int, int);
extern void highvideo (void);
extern void normvideo (void);
extern void _setcursortype (int);
extern int kbread (void);
extern struct sessmgr_sw *sm_lookup (const char *, const char **);
extern struct session *sm_newsession (const char *, const char *, int, int);
extern int sm_blocked (struct session *);
extern int sm_usestdio (void);

/* from lxasy.c */
extern void detach_all_asy (void);

/*
 * unix functions - can't include system headers or we'll have major collisions
 * because JNOS usurps e.g. all the socket and timer calls
 */
#ifdef __cplusplus
extern "C" {
#endif

#ifndef _UNIXTM_H
extern long dostounix (struct date *, struct time *);
#endif
#ifndef _SYS_STAT_H
extern int mkdir (const char *pthname, mode_t mode);
#endif
#ifdef __FreeBSD__
#include <unistd.h>
#else
extern int getpid (void);
extern int unlink (const char *);
extern int fork (void);
extern int execvp (const char *, const char **);
extern off_t lseek (int, off_t, int);
extern int read (int, void *, unsigned);
extern int close (int);
extern int access (const char *, int);
extern int write (int, const void *, unsigned);
extern char *getcwd (char *, int);
extern int pipe (int *);
extern int execv (const char *, const char **);
extern int execve (const char *, const char **, const char **);
extern int rmdir (const char *);
#endif
#if 0
extern int kill (pid_t, int);
extern char *strdup (const char *);
#endif
extern char *mktemp (char *);
struct timeval;
#ifndef lint
extern int select (int, fd_set *, fd_set *, fd_set *, struct timeval *);
#endif

#ifdef __cplusplus
}
#endif

#define newscreen j_newscreen

#define _NOCURSOR 0
#define _NORMALCURSOR 1
#define _SOLIDCURSOR 2

#ifndef _GLOBAL_H
#define strnicmp strncasecmp
#define stricmp strcasecmp
#endif

#define SETVBUF 1
#endif	/* _UNIX_H */
