#include <stdio.h>
#ifdef __bsdi__
#include <stdlib.h>
#endif
#ifdef  __STDC__
#define x      x
#else
#define x      ()
#endif

#ifndef OPTIONAL
#define OPTIONAL
#endif

#include <string.h>
#include "md5.c"


#if !defined(_lint)
static char hashrcsid[] OPTIONAL = "$Id: hasher.c,v 1.10 1997/06/28 16:46:13 root Exp root $";
#endif

char *savedbasename;

void my_basename(char*);

void
my_basename (char *name)
{
char *retval;

	if (!(retval = strrchr (name, '/')))
		retval = name;
	savedbasename = ++retval;
}



/* Compute MD5 hash of local file */
int
main(int argc, char **argv)
{
FILE *fp;
MD5_CTX md;
char buf[BUFSIZ];
int len, k;

	my_basename (argv[0]);
	if (argc < 2)	{
		fprintf (stdout, "%s: Usage\n\t%s filename [filename]...\n",savedbasename, savedbasename);
		exit (1);
	}

	for (k = 1; k < argc; k++)	{
		fp = fopen (argv[k], "rb");
		if (!fp)	{
			fprintf (stdout, "%s: Can't open file '%s'\n", savedbasename, argv[k]);
			continue;
		}

		MD5Init(&md);

		while((len = fread(buf,1,BUFSIZ,fp)) != 0)
			MD5Update(&md,(unsigned char *)buf,len);
		fclose (fp);
		MD5Final(&md);
		printf ("%-16s\t", argv[k]);
		for(len=0;len<16;len++)	/* Write hashed password */
			printf("%02x",md.digest[len] & 0xff);
		putchar ('\n');
	}
	return 0;
}


