/* Machine or compiler-dependent portions of kernel
 * Turbo-C version for PC
 * Copyright 1991 Phil Karn, KA9Q
 */
#include "global.h"
#include "commands.h"
#include "proc.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: ksubr.c,v 1.26 1997/06/28 16:46:13 root Exp root $";
#endif

#ifdef TNOS_68K
/* Template for contents of jmp_buf for 68302 */
struct env {
	unsigned	_pc;
	unsigned	_d0;
	unsigned	_d1;
	unsigned	_d2;
	unsigned	_d3;
	unsigned	_d4;
	unsigned	_d5;
	unsigned	_d6;
	unsigned	_d7;
	unsigned	_a0;
	unsigned	_a1;
	unsigned	_a2;
	unsigned	_a3;
	unsigned	_a4;
	unsigned	_a5;
	unsigned	_a6;
	unsigned	_a7;
	unsigned	_xtra;
};

#endif

#if !defined(MSDOS) && defined(USE_SETSTACK)
/*
 * This needs to be extern because it is referenced by setstack()
 */
void *newstackptr;
void setstack(void);
#endif

#if defined(UNIX) && !defined(USE_SETSTACK)
/*
 * There are several different ways to implement jmp_buf's.  We use macros to
 * extract the fields.  Note that these must expand into lvalues, because we
 * load them during process initialization.  Current code only uses _SP and
 * _PC; this may change.
 *
 * I should fold the DOS code into this, but then I need to worry about
 * segments.  No thanks.
 */

#ifdef M_UNIX
/*
 * I am unsure of these; the i386 contents are not documented in 3.2.2.  I
 * guessed at them by comparing "info regs" with the contents of a jmp_buf
 * immediately after a setjmp().
 */
#define _PC(p) (p->env[5])
#define _SP(p) (p->env[4])
#define _BP(p) (p->env[3])
#endif

#ifdef linux
#ifdef JB_PC
#define _PC(p) (p->env->__jmpbuf[JB_PC])
#define _SP(p) (p->env->__jmpbuf[JB_SP])
#define _BP(p) (p->env->__jmpbuf[JB_BP])
#else
#define _PC(p) (p->env->__pc)
#define _SP(p) (p->env->__sp)
#define _BP(p) (p->env->__bp)
#endif
#endif

#ifdef sun
#define _PC(p) (p->env[3])
#define _SP(p) (p->env[2])
#endif

#endif

static int stkutil (struct proc *pp);
static void pproc(struct proc *pp);



void
kinit()
{
#ifdef TNOS_68K
	/* Remember location 0 pattern to detect null pointer derefs */
	oldNull = *(unsigned short *)NULL;
#endif
	/* Initialize signal queue */
	Ksig.wp = Ksig.rp = Ksig.entry;
}



int
dokstat (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
	tprintf ("ksigs %lu queued %lu hiwat %u woken %lu nops %lu dups %lu\n",
		Ksig.ksigs, Ksig.ksigsqueued, Ksig.maxentries, Ksig.ksigwakes,
		Ksig.ksignops, Ksig.duksigs);
	tprintf ("kwaits %lu nops %lu from int %lu\n",
		Ksig.kwaits, Ksig.kwaitnops, Ksig.kwaitints);
	Ksig.maxentries = 0;
	return 0;
}



/* Print process table info
 * Since things can change while ps is running, the ready proceses are
 * displayed last. This is because an interrupt can make a process ready,
 * but a ready process won't spontaneously become unready. Therefore a
 * process that changes during ps may show up twice, but this is better
 * than not having it showing up at all.
 */
int
ps (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
register struct proc *pp;
int i;

	tprintf("Uptime %s\n", tformat (secclock()));

	(void) dokstat (0, NULLCHARP, NULL);
	tputs ("PID      "
#ifndef USE_SETSTACK
		"SP       "
#endif
		"stksize  maxstk   event    fl  in  out  name\n");

	for (pp = Susptab; pp != NULLPROC; pp = pp->next)
		pproc (pp);

	for (i = 0; i < PHASH; i++)
		for (pp = Waittab[i]; pp != NULLPROC; pp = pp->next)
			pproc (pp);

	for (pp = Rdytab; pp != NULLPROC; pp = pp->next)
		pproc (pp);

	if (Curproc != NULL)
		pproc (Curproc);

	return 0;
}



static void
pproc (struct proc *pp)
{
	tprintf ("%8.8lx "
#ifndef USE_SETSTACK
		"%8.8lx "
#endif
                "%8.8lx %8.8lx %8.8lx %c%c%c %3d %3d  %s\n", (uint32) pp,
#ifndef USE_SETSTACK
#ifdef MSDOS
                pp->env[0].__esp,
#else
                (long) _SP(pp),
#endif
#endif
                (int32) pp->stksize, (int32) stkutil(pp),
                (uint32) pp->event,
                pp->i_state ? 'I' : ' ',
		(pp->state & WAITING) ? 'W' : ' ',
		(pp->state & SUSPEND) ? 'S' : ' ',
		pp->input, pp->output, pp->name);
}



static int
stkutil (struct proc *pp)
{
unsigned i;
register int16 *sp;

	if (pp->stack == (int16 *) 0LU)
		return (0);
#ifdef UNIX
#ifdef linux
	if (pp->stack == (int16 *) 0xC0000000LU)		/*lint !e58 */
#else
	if (pp->stack == (int16 *) 0x80000000LU)
#endif
		return ((int) pp->stksize);
#endif
	i = pp->stksize;
	for (sp = pp->stack; *sp == STACKPAT && sp < pp->stack + pp->stksize; sp++)
		i--;
	return ((int)i);
}



/* Machine-dependent initialization of a task */
void
psetup (pp, iarg, parg1, parg2, pc)
struct proc *pp;	/* Pointer to task structure */
int iarg OPTIONAL;	/* Generic integer arg */
void *parg1 OPTIONAL;	/* Generic pointer arg #1 */
void *parg2 OPTIONAL;	/* Generic pointer arg #2 */
void (*pc)(int,void*,void*);           /* Initial execution address */
{
#ifdef MSDOS
static uint32 *stktop;
#else
#ifndef USE_SETSTACK
static int16 *stktop; /* KF8NH was "int", this breaks 32-bit code */
#endif
#endif

#ifdef USE_SETSTACK
	/*
	 * setstack() is a routine borrowed from WAMPES.  It's actually
	 * an assembly language routine inside setsp.c.  TNOS needs to
	 * return the proc pointer, so I have to play a little game here.
	 * I do a setjmp() call, establishing this piece of code as the
	 * process context.  Note that we won't really be on the new
	 * process stack when setjmp() returns the first time.  The
	 * actual switchover doesn't happen until the process gets scheduled
	 * and the setjmp() returns for the second time.
	 */
	if (setjmp(pp->env))	{
		newstackptr = Curproc->stack + Curproc->stksize;
		setstack();
		/* We are now running on the new process stack.  We can call
		 * the function and everything will be hunky-dory. */
		(Curproc->func)(Curproc->iarg, Curproc->parg1, Curproc->parg2);

		/* Clean up, just in case the function returns. */
		killself();
	} else {
		/* Still running in the old context.  Stuff the function
		 * pointer away so we can call the function later. */
		pp->func = pc;
		/* Run with interrupts on */
		pp->i_state = 1;
		return;
	}
#endif	/* !USE_SETSTACK */

#ifdef MSDOS
	/* Set up stack to make it appear as if the user's function was called
	 * by killself() with the specified arguments. When the user returns,
	 * killself() automatically cleans up.
	 *
	 * First, push args on stack in reverse order, simulating what C
	 * does just before it calls a function.
	 */
	stktop = (uint32 *)((uint32)pp->stack + (uint32) (pp->stksize * sizeof (int16)));
	*--stktop = (uint32)parg2;
	*--stktop = (uint32)parg1;
	*--stktop = (uint32)iarg;

	/* Now push the entry address of killself(), simulating the call to
	 * the user function.
	 */
	*--stktop = (uint32)killself;

	/* Set up task environment. Note that for Turbo-C, the setjmp
	 * sets the interrupt enable flag in the environment so that
	 * interrupts will be enabled when the task runs for the first time.
	 * Note that this requires newproc() to be called with interrupts
	 * enabled!
	 */
	(void) setjmp(pp->env);
	pp->env[0].__esp = (uint32)stktop;
	pp->env[0].__eip = (uint32)pc;
	pp->env[0].__ebp = 0;		/* Anchor stack traces */
	/* Task initially runs with interrupts on */
	pp->i_state = 1;
#endif

#if !defined(USE_SETSTACK) && !defined(MSDOS)
	/* Set up stack to make it appear as if the user's function was called
	 * by killself() with the specified arguments. When the user returns,
	 * killself() automatically cleans up.
	 *
	 * First, push args on stack in reverse order, simulating what C
	 * does just before it calls a function.
	 */

	stktop = (int16 *)(pp->stack + pp->stksize); /* KF8NH as above */

#ifdef UNIX
#define THEMASK 0xFFFF0000LU

#ifdef IS_LITTLE_ENDIAN
	*--stktop = (((unsigned long) parg2 & THEMASK) >> 16) & 0x0000FFFF;
	*--stktop = ((unsigned long) parg2 & 0x0000FFFF);
	*--stktop = (((unsigned long) parg1 & THEMASK) >> 16) & 0x0000FFFF;
	*--stktop = ((unsigned long) parg1 & 0x0000FFFF);
	*--stktop = (((unsigned long) iarg & THEMASK) >> 16) & 0x0000FFFF;
	*--stktop = ((unsigned long) iarg & 0x0000FFFF);
	*--stktop = (((unsigned long) killself & THEMASK) >> 16) & 0x0000FFFF;
	*--stktop = ((unsigned long) killself & 0x0000FFFF);
#else
	*--stktop = ((unsigned long) parg2 & 0x0000FFFF);
	*--stktop = (((unsigned long) parg2 & THEMASK) >> 16) & 0x0000FFFF;
	*--stktop = ((unsigned long) parg1 & 0x0000FFFF);
	*--stktop = (((unsigned long) parg1 & THEMASK) >> 16) & 0x0000FFFF;
	*--stktop = ((unsigned long) iarg & 0x0000FFFF);
	*--stktop = (((unsigned long) iarg & THEMASK) >> 16) & 0x0000FFFF;
	*--stktop = ((unsigned long) killself & 0x0000FFFF);
	*--stktop = (((unsigned long) killself & THEMASK) >> 16) & 0x0000FFFF;
#endif	/* IS_LITTLE_ENDIAN */

#else	/* UNIX */
	*--stktop = parg2;
	*--stktop = FP_OFF(parg2);
	*--stktop = FP_OFF(killself);
#endif	/* UNIX */

	/* Set up task environment. Note that for Turbo-C, the setjmp
	 * sets the interrupt enable flag in the environment so that
	 * interrupts will be enabled when the task runs for the first time.
	 * Note that this requires newproc() to be called with interrupts
	 * enabled!
	 */
	setjmp(pp->env);
#ifdef UNIX
#ifdef sun
	_SP(pp) = (int)stktop;
	_PC(pp) = (int)pc;
#else	/* sun */
#ifdef JB_PC
	_SP(pp) = (int) stktop;
	_BP(pp) = (int) stktop;
	_PC(pp) = (int) pc;
#else
	_SP(pp) = stktop;
	_BP(pp) = stktop;
	_PC(pp) = pc;
#endif
#endif	/* sun */
#else	/* UNIX */
	ep = (struct env *)pp->env;
	ep->_d1 = parg1;
	ep->_d0 = iarg;
	ep->_a7 = stktop;
	ep->_pc = pc;
#endif	/* UNIX */
	/* Task initially runs with interrupts on */
	pp->i_state = 1;
#endif	/* !USE_SETSTACK && !MSDOS */
}



unsigned
phash (volatile void *event)
{
register unsigned x;

	/* Fold the two halves of the pointer */
	x = (unsigned) event;

	/* If PHASH is a power of two, this will simply mask off the
	 * higher order bits
	 */
	return x % PHASH;
}
