#ifndef _MAILBOX_H
#define _MAILBOX_H
/* Defines for the ax.25 mailbox facility */
#define _NUMMBX          40              /* max number of mailbox sessions */
#ifndef _TIMER_H
#include "timer.h"
#endif
#ifndef _AX25_H
#include "ax25.h"
#endif
#ifndef _CONFIG_H
#include "config.h"
#endif
#ifndef _TIPMAIL_H
#include "tipmail.h"
#endif
#if !defined(_TIME_H) && !defined(__dj_include_time_h_)
#include <time.h>
#endif
#include "mailfor.h"
#include "fwdparse.h"

#ifdef FBBFWD	/* forward reference */
struct fbbpacket;
#endif

extern int NUMMBX;

/* a mailbox entry */
struct let {
        long    start;
        long    size;
        long    bid;
        int16   status;
};

#define MAXPWDLEN 30
#define MBXLINE     128     /* max length of line */
struct mbx {
        int state ;                             /* mailbox state */
#define MBX_LOGIN       0               /* trying to log in */
#define MBX_CMD         1               /* in command mode */
#define MBX_SUBJ        2               /* waiting for a subject line */
#define MBX_DATA        3               /* collecting the message */
#define MBX_REVFWD      4               /* reverse forwarding in progress */
#define MBX_TRYING      5               /* pending forwarding connection */
#define MBX_FORWARD     6               /* established forwarding connection */
#define MBX_GATEWAY	7		/* gatewaying somewhere */
#define MBX_READ	8		/* reading a message */
#define MBX_UPLOAD	9		/* uploading a file */
#define MBX_DOWNLOAD	10		/* downloading a file */
#define MBX_CONVERS	11		/* Using convers mode */
#define MBX_CHAT	12		/* Chatting with sysop */
#define MBX_WHAT	13		/* Listing files */
#define MBX_SYSOPTRY	14		/* Trying sysop */
#define MBX_SYSOP	15		/* Is sysop */
#define MBX_XMODEM_RX	16		/* receiving xmodem */
#define MBX_XMODEM_TX	17		/* sending xmodem */
#define MBX_TUTOR	18		/* using Tutorial server */
#define MBX_MAXSTATE	18
    int family;             /* Type of incoming connection */
    char name[20] ;         /* Name of remote station */
    char call[AXALEN];      /* User call in shifted form, if applicable*/
    char *to ;          /* To-address in form user or user@host */
        char *origto ;                  /* Original To-address, if rewritten */
        char *tofrom ;                  /* Optional <from in to-address */
    char *origbbs ;         /* Original bbs, if tracing R: lines */
    char *tomsgid ;         /* Optional $msgid in to-address */
    char *subject ;         /* Message subject */
    char *date ;            /* Date of the message */
    FILE *tfile ;           /* Temporary file for message, or */
                                        /* forwarding file. */
    FILE *tfp;              /* Temporary file when reading R: headers */
    char line[MBXLINE+1] ;  /* Room for null at end */
        int mbnum ;             /* which mailbox session is this? */
        int32 sid ;             /* Characteristics indicated by the SID */
                                /* banner of the attaching station.  If */
                                /* no SID was sent, this is zero.  If an */
                                /* SID of any kind was received, it is */
                                /* assumed that the station supports */
                                /* abbreviated mail forwarding mode. */
#define MBX_SID         0x01    /* Got any SID */
#define MBX_RLI_SID     0x02    /* This is an RLI BBS, disconnect after F> */
#define MBX_HIER_SID    0x04    /* The BBS supports "hierarchical routing */
                                /* designators." */
#define MBX_FBB         0x08    /* This is an FBB BBS */
#define MBX_FBBCMP      0x10    /* This FBB supports compression */
#define MBX_TNOS        0x20    /* supports TNOS Compressed streams */
#define MBX_LL          0x40    /* LAN-LINK system */
                                /* Space here for others, currently not of */
                                /* interest to us. */
#define MBX_EXPERT      0x80    /* expert user status */
#define MBX_AREA        0x100   /* show area in prompt */
#define MBX_NRID        0x200   /* use netrom ident */
#define MBX_RDMOTD      0x400   /* has read motd file */
#define MBX_STATS       0x800   /* scan for new messages on login ? */
#define MBX_MID         0x1000  /* BBS supports MID's */
#define MBX_GFX         0x2000  /* use ANSI color graphics */
#define MBX_FBBFWD      0x4000  /* use FBB-style forwarding */
#define MBX_DELEGATE    0x8000  /* is forwarding delegation on */
#define MBX_HOLD       0x10000  /* hold all mail entered */
#define MBX_CLOCK      0x20000	/* requests remote to set it's clock - TNCs */
#define MBX_HTTP       0x40000	/* remote supports HTTP/PBBS extension */
#define MBX_XFWD       0x80000  /* This PBBS supports X-forwarding protocol */
#define MBX_SENTSID 0x40000000	/* we have sent one (and only one) sid */
    char stype ;        /* BBS send command type (B,P,T, etc.) */
    char special;               /* special mode flag for '~' and '^' */
        int type ;              /* Type of session when invoking "chat" */
        int user;               /* User linkage area */
        char escape;            /* Escape character */
        long privs;             /* Privileges (taken from Ftpusers file) */
#ifndef AX25_CMD
#define AX25_CMD     0x00000008 /* AX.25 gateway operation allowed */
#define TELNET_CMD   0x00000010 /* Telnet gateway operation allowed to non-ampr */
#define NETROM_CMD   0x00000020 /* NET/ROM gateway operation allowed */
#define SYSOP_CMD    0x00000040 /* Remote sysop access allowed */
#define EXCLUDED_CMD 0x00000080 /* This user is banned from the BBS */
#endif
/* 256 and 512 are used in PPP*/
/* but 256 is used internally in the BBS to indicate a sysop-requested chat
   and 512 is used internally in the BBS to indicate a '!' command in progress */
#define SYS_CHAT     0x00000100 /* Sysop generated chat session */
#define ALL_AREAS    0x00000200 /* BBS '!' command in progress */
#define NO_SENDCMD   0x00000400 /*Disallow send command*/
#define NO_READCMD   0x00000800 /*Disallow read command*/
#define NO_3PARTY    0x00001000 /*Disallow third-party mail*/
#define IS_BBS       0x00002000 /*This user is a bbs*/
#define IS_EXPERT    0x00004000 /*This user is an expert*/
#define NO_CONVERS   0x00008000 /*Disallow convers command */
#define NO_ESCAPE    0x00010000 /* Default is no escape */
#define AMPR_CMD     0x00020000 /* Ampr Telnet gateway operation allowed */
#define NO_LINKEDTO  0x00040000	/* No '*** LINKED TO' allowed */
#define NO_NON23     0x00080000 /* No telnet to non-default telnet port */
#define NO_SLIP      0x00100000 /* This user can't exit tipmail to do IP */
#define NO_PBBSMAIL  0x00200000 /* Disallow PBBS mail addresses */
#define NO_INETMAIL  0x00400000 /* Disallow non-ampr mail addresses */
#define NO_AMPRMAIL  0x00800000 /* Disallow ampr mail addresses */
#define HOLD_MAIL    0x01000000 /* Any mail entered held for sysop review */
#define NO_HTTP_IP   0x02000000 /* Disallow http PBBS access via IP */
#define NO_HTTP_AX   0x04000000 /* Disallow http PBBS access via AX25 */
#define NO_HTTP_MAIL 0x08000000 /* Disallow sending email via http PBBS */
#define WAS_ANONY    0x40000000 /* User was anonymous 'univperm' */
    char *path;     /* Directory path */
    char *startmsg;     /* Message to be sent at connect through any
                                of the gateways */
    int current;        /* the current message number */
        int nmsgs;              /* number of messages in this mail box */
        int newmsgs;            /* number of new messages in mail box */
	int newmsgsonentry;	/* number of new messages when we entered area */
        int hmsgs;              /* number of held messages in this mail box */
        int change;             /* mail file changed */
#define CHG_READ        0x01
#define CHG_DELETE      0x02
#define CHG_WP		0x4000
#define CHG_NORMAL	0x00ff
#define CHG_SPECIAL	0x7f00

        int anyread;            /* true if any message has been read */
        FILE *mfile;            /* mail data file pointer */
        char area[64];          /* name of current mail area */
    int morerows;       /* Number of lines before -more- prompt */
    int update;         /* Update the user preferences */
/* Next two are used by userlog code - WG7J */
        long lastread;          /* number of last read message in area */
    long newlastread;   /* id of new last listed message in area */
        long mboxsize;          /* size of mailbox when opened */
        long mysize;            /* size of my private mailbox */
        struct let *mbox;
    struct timer tdisc; /* Inactivity timeout timer - WG7J */
        char *stdinbuf;         /* the stdio buffer for the mail file */
        char *stdoutbuf;        /* the stdio file io buffer for the temp file */
        char *home;             /* the HOME BBS for this user */
        time_t logontime;         /* time of this login */
        struct tipcb *tip;       /* tip structure if tip mail incoming */
        char colorset[2];       /* current colorset */
        char usecolor;          /* use color this login ? */
        char inmessage;         /* are we in a message read/write? */
        char *realname;         /* user's real name */
        int linemode;
        struct proc *ps;        /* process pointer for this mbox user */
	FILE *quickfile;	/* used by reqsvr for Internet Callbook lookup */
	struct fwdbbs *fwdbbs;	/* structure used for forwarding w/info on the BBS */
#ifdef FBBFWD
	struct fbbpacket *msglst; /* fbb message list structure */
#endif
	int subchannel;		/* allocated subchannel slot (for forwarding) */
} ;
#define         NULLMBX         (struct mbx *)0

/* Structure used for automatic flushing of gateway sockets */
struct gwalarm {
        int s1;
        int s2;
        struct timer t;
};

/* Log all gateway connects to the logfile - WG7J */
#define GWTRACE 1

/* In converse.c */
void mbox_converse (int fd,char *name,int channel,struct mbx *mbox);
extern int ShowConfLinks (int s,int full);
extern int ShowConfUsers (int s, char *athost);

/* In mailbox.c */
extern struct mbx **Mbox ;
extern char Noperm[];
extern void (*Listusers) (int s);
extern int ThirdParty;
extern int Mtrace;
extern int FBBtrace;
extern int Xtrace;

int mbxrecvline (struct mbx *m);
int gw_connect (struct mbx *m,int s,struct sockaddr *fsocket,int len);
void mbx_SendSid (struct mbx *m);

void pbbs_incom (int s,void *t,void *p);
struct mbx *newmbx (int fwding);
void exitbbs (struct mbx *m);
int domboxbye (int argc,char *argv[],void *p);
int mbx_parse (struct mbx *m);
void changearea (struct mbx *m,char *area,int setit);
char *rewrite_address (const char *addr, int recursionlevel);
void listusers (int s);
void bbscolorcls (struct mbx *m);
void bbscolorchange (struct mbx *m,const char *str);
int doxmodem (char mode,char *filename,void *p);
int dombtelnet (int argc,char *argv[],void *p);
int dombports (int argc,char *argv[],void *p);
int iscall (char *call);

/* In mailbox2.c */
int dombupload (int argc,char *argv[],void *p);

/* in pbbscmd.c */
extern char Mbnrid[];
int dombuserinfo (int argc,char *argv[],void *p);
time_t loguser (struct mbx *m);
void setmbnrid (void);

/* In tipmail.c */
extern unsigned Tiptimeout;

#ifdef TUTOR
/* In tutor.c */
void mbscripthook (struct mbx *m,const char *hookfile);
#endif

#ifndef _FORWARD_H
#include "forward.h"
#endif

extern struct bbs MyFwds[NUMFWDBBS];

#endif  /* _MAILBOX_H */

