#ifdef DEMO
#include <stdio.h>
#else
#include "global.h"
#include "commands.h"
#include "proc.h"
#endif

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: merge.c,v 1.10 1996/12/23 22:44:37 root Exp root $";
#endif

FILE *
fopennew (fname, mode)
const char *fname, *mode;
{
char newname[256];

	sprintf (newname, "%s.new", fname);
	return (fopen (newname, mode));
}


FILE *
fopentmp (fname, mode)
const char *fname, *mode;
{
char newname[256];

	sprintf (newname, "%s.tmp", fname);
	return (fopen (newname, mode));
}


int
merge (fname)
const char *fname;
{
FILE *fp, *fpnew;
char buf[128], name[128];

	sprintf (name, "%s.new", fname);
	if ((fpnew = fopen(name, "rt")) == (FILE *)NULL)
		return 0;
	if ((fp = fopen(fname, "r+t")) == (FILE *)NULL)		{
		fclose (fpnew);
		(void) rename(name, fname);
		return 1;
	}
	kwait (NULL);
	fseek (fp, 0, 2);
	while (fgets (buf, 128, fpnew))		{
		kwait (NULL);
		fputs (buf, fp);
	}
	fclose (fp);
	fclose (fpnew);
	(void) remove (name);
	return 1;
}


#ifdef DEMO

int
kwait (i)
int i;
{
}


void
main ()
{
	merge ("/nos/src/test1");
}

#endif
