/* Callbook server */
/* Mods by KO4KS */
#include "global.h"
#include "commands.h"
#include "files.h"
#include "mbuf.h"
#include "socket.h"
#include "session.h"
#include "mailbox.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: calldbd.c,v 1.17 1997/08/19 01:19:22 root Exp root $";
#endif

#if defined(CALLBOOK) || defined(CALLSERVER) || defined(SAMCALLB) || defined(QRZCALLB)

extern char *Callserver;	/* buckbook.c */

int Scallbook = -1;		/* Prototype socket for service */

static void calldbd (int s, void *unused, void *p);


#if defined(SAMCALLB) || defined(QRZCALLB)
extern int cb_lookup (int s, char *call, FILE * fp);
#else
extern void cb_lookup (int s, char *call);	/* in buckbook.c  */
#endif


/* Start up callsign database service */
int
cdbstart (argc, argv, p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	return (installserver (argc, argv, &Scallbook, "Callbook listener", IPPORT_CALLDB,
		INADDR_ANY, "calldbd", calldbd, 1024, NULL));
}


static void
calldbd (s, unused, p)
int s;
void *unused OPTIONAL;
void *p OPTIONAL;
{
char user[80];
#if defined(SAMCALLB) || defined(QRZCALLB)
int err;
#endif

	(void) sockmode (s, SOCK_ASCII);
	(void) sockowner (s, Curproc);
	if (recvline (s, (unsigned char *) user, 80) == -1)
		return;
	rip (user);
	log (s, "Callbook lookup: %s", user);
	if (strlen (user) == 0)
		usputs (s, "No Callbook information available\n");
	else {
#if defined(SAMCALLB) || defined(QRZCALLB)
		if ((err = cb_lookup (s, user, (FILE *) 0)) != 0)
			usputs (s, (err == 2) ? "No Callbook information available\n" : "Callbook not active\n");
#else
		cb_lookup (s, user);
#endif
	}
	close_s (s);
}


int
cdb0 (argc, argv, p)
int argc OPTIONAL;
char *argv[] OPTIONAL;
void *p OPTIONAL;
{
	return (deleteserver (&Scallbook));
}

#endif



/* This routine has been expanded upon, and is now located in buckbook.c
  - kb7yw Mon  01-27-1992   - except if using the SAM database - ko4ks */

#if defined(CALLCLI) || defined(SAMCALLB) || defined(QRZCALLB)
char *Callserver;

int
docallserver (argc, argv, p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	if (argc < 2) {
		if (Callserver != NULLCHAR)
			tprintf ("The callserver's host name is: %s\n", Callserver);
		else {
			tputs ("Callserver not configured!\n");
			tputs ("Usage: callserver hostname OR callserver ip_address\n");
		}
	} else {
		if (Callserver != NULLCHAR)
			free (Callserver);
		Callserver = strdup (argv[1]);
	}
	return 0;
}

#endif
