#ifndef	_CMDPARSE_H
#define	_CMDPARSE_H

#define	NARG		30	/* Max number of args to commands */

struct cmds {
	const char *name;		/* Name of command */
	int (*func) (int argc,char *argv[],void *p);
				/* Function to execute command */
	int stksize;		/* Size of stack if subprocess, 0 if synch */
	int  argcmin;		/* Minimum number of args */
	const char *argc_errmsg;	/* Message to print if insufficient args */
};
#ifndef	NULLCHAR
#define	NULLCHAR	(char *)0
#endif

/* In cmdparse.c: */
int cmdparse (struct cmds cmds[],char *line,void *p);
int subcmd (struct cmds tab[],int argc,char *argv[],void *p);
int setbool (int *var,char const *label,int argc,char *argv[]);
int bit16cmd (int16 *bits, int16 mask, const char *label, int argc, char *argv[]);
int setint (int *var,char const *label,int argc,char *argv[]);
int setlong (int32 *var,char const *label,int argc,char *argv[]);
int setshort (unsigned short *var,char const *label,int argc,char *argv[]);
int setuns (unsigned *var,char const *label,int argc,char *argv[]);
int setintrc (unsigned short *var,char const *label,int argc,char *argv[],int minval,int16 maxval);

#endif	/* _CMDPARSE_H */
