/* PBBS Import file client
 * Copyright 1995 Brian A. Lantz, KO4KS
 */
#include "global.h"
#ifdef BBSIMPORT
#include "ctype.h"
#include "commands.h"
#include "mbuf.h"
#include "socket.h"
#include "session.h"
#include "netuser.h"
#include "mailbox.h"
#include "files.h"
#include "smtp.h"
#include "mailutil.h"


#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: import.c,v 1.20 1997/09/07 21:18:28 root Exp root $";
#endif

void importcmd (int mode, char *bbsname);
static void importtick (void *p);
static void parseimport (struct mbx *m);

static struct timer importtimer;
#define MSPMINUTE (1000L*60L)


int
doimport(argc,argv,p)
int argc;
char *argv[];
void *p OPTIONAL;
{
	if(argc < 2){
		tprintf("import timer: %lu/%lu minutes\n",
			read_timer(&importtimer)/MSPMINUTE,
			dur_timer(&importtimer)/MSPMINUTE);
		return 0;
	}
	if(*argv[1] == 'n') {
		importtick(NULL);
		return 0;
	}
	stop_timer (&importtimer);	/* just in case */
	importtimer.func = (void (*)(void *))importtick;/* what to call on timeout */
	importtimer.arg = NULL;		/* dummy value */
	set_timer(&importtimer,atol(argv[1])*MSPMINUTE); /* set timer duration */
	start_detached_timer(&importtimer);     /* fire it up */
	return 0;
}

static void
importtick(p)
void *p OPTIONAL;
{
    start_detached_timer(&importtimer);
    /* Spawn off the process */
    if (newproc("BBS import",(unsigned)1024,(void (*)(int,void*,void*))importcmd,0,(void *)0,(void *)0,0) == NULLPROC)
	log (-1, "Couldn't start Import process");
}

void
importcmd (int mode, char *bbsname)
{
struct mbx *m;
char buf[80], tempname[1024];
struct ffblk ff;
int oldoutput;
int result = 0;

	m = newmbx (1);
	oldoutput = Curproc->output;
	Curproc->output = 0;
	m->user = Curproc->output;
	m->ps = Curproc;
	m->state = MBX_FORWARD;
	m->sid = MBX_SID;
	strncpy (m->name, (bbsname) ? bbsname : "import", 20);

	if (!mode)	{
		sprintf(buf,"%s/*.imp",IMPORTDir);
		result = findfirst(buf, &ff, 0);
	}
	if (!result)	{
		do	{
			kwait(NULL);    /* Let others run */
			if (mode)
				sprintf (tempname, "%s/import.txt", Mailspool);
			else
				sprintf (tempname, "%s/%s", IMPORTDir, ff.ff_name);
			if ((m->quickfile = fopen (tempname, READ_TEXT)) != NULLFILE)	{
				while (!feof(m->quickfile))	{
					kwait (NULL);
					m->change = 0;
					(void) fgets (m->line, MBXLINE, m->quickfile);
					if (feof(m->quickfile))
						continue;
					rip (m->line);
					if (!*m->line || !strnicmp (m->line, "/ex", 3))
						continue;
					if (tolower(*m->line) != 's' || m->line[2] != ' ')	{
						parseimport (m);
						result = 1;
						continue;
					}
					(void) mbx_parse(m);
					if (!m->change)	{	/* skip till '/EX' */
						while (!feof(m->quickfile))	{
							(void) fgets (m->line, MBXLINE, m->quickfile);
							if (feof(m->quickfile))
								continue;
							if (!strnicmp (m->line, "/ex", 3))
								break;
						}
					}
				}
				(void) fclose (m->quickfile);
#if 1
				unlink (tempname);
#endif
			}
		if (!mode)
			result = findnext(&ff);
		else
			result = 1;
			
		} while (!result);
	}

	smtptick(NULL);		/* wake SMTP to send that mail */
	Curproc->output = oldoutput;
	m->change = 0;
	exitbbs(m);
	return;
}

static void
parseimport (m)
struct mbx *m;
{
char bid[24], to[80], from[60], subject[100];
char msgtype = 'P', *cp, *retval;
FILE *savefp;
int done, headers, first = 1;

	savefp = m->quickfile;
	done = 0;
	headers = 0;
	while (!feof(savefp))	{
		while (!done)	{
			if (first)
				first = 0;
			else	{
				retval = fgets (m->line, MBXLINE, savefp);
				if (feof(savefp) || retval == NULLCHAR)
					goto done;
			}
			rip (m->line);
			if (!*m->line)	{
				done = 1;
				continue;
			}
			switch (htype (m->line))	{
				case DATE:	/* do nothing with these */
				case CC:	break;
				case FROM:	cp = strchr (m->line, '@');
						if (cp)
							*cp = 0;
						strncpy (from, &m->line[6], 59);
						break;
				case TO:	strncpy (to, &m->line[4], 79);
						break;
				case SUBJECT:	strncpy (subject, &m->line[9], 99);
						break;
				case XBID:	strncpy (bid, &m->line[7], 23);
						break;
				case MSGTYPE:	msgtype = m->line[11];
						break;
				case BBSTYPE:	msgtype = m->line[16];
						break;
				case MSGID:	cp = strchr (m->line, '>');
						if (cp)
							*cp = 0;
						cp = strchr (m->line, '@');
						if (cp)	{
							if (!strnicmp (".bbs", &m->line[strlen (m->line) - 4], 4))
								*cp = 0;
							else
								*cp = '_';
						}
						cp = strchr (m->line, '<');
						if (cp)
							strncpy (bid, ++cp, 24);
						break;
				default:	continue;
			}
			headers = 1;
		}
		if (!headers)	{
			done = 0;
			continue;
		}
		m->quickfile = tmpfile ();
		fprintf (m->quickfile, "%s\n", subject);
		while (!feof(savefp))	{
			retval = fgets (m->line, MBXLINE, savefp);
			if (feof(savefp) || retval == NULLCHAR)
				goto done;
			fputs (m->line, m->quickfile);
			if (!strnicmp (m->line, "/ex", 3))
				break;
		}
		sprintf (m->line, "S%c %s < %s $%s", msgtype, to, from, bid);
		rewind (m->quickfile);
		(void) mbx_parse(m);
		(void) fclose (m->quickfile);
		done = 0;
		headers = 0;
	}
done:
	m->quickfile = savefp;
}


#endif /* BBSIMPORT */
