/* Polled Kiss ala G8BPQ for JNOS
 * Copyright 1993, Johan. K. Reinalda, WG7J
 * Hereby placed in the public domain.
 */
#include "global.h"
#include "slip.h"
#include "devparam.h"
#include "kisspoll.h"
  
#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: kisspoll.c,v 1.10 1997/08/19 01:19:22 root Exp root $";
#endif

#ifdef POLLEDKISS
  
#define WAITTIME 165L
  
void
kiss_poller (xdev, p1, p2)
int xdev;
void *p1;
void *p2 OPTIONAL;
{
int i;
long interval = (long)p1;
struct mbuf *bp;
struct iface *master,*iface;
struct slip *sp = &Slip[xdev];
  
	/* The actual physical interface */
	master = sp->kiss[0];
  
	for ( ; ; ) {
		for (i = 0; i < 16; i++) {
			if ((iface=sp->kiss[i]) == NULL)
				continue;
  
			/* Get buffer for the poll packet, and generate it */
			if ((bp = alloc_mbuf (2)) == NULL)
				continue;
			bp->data[0] = PARAM_POLL;
			bp->data[0] |= (char)(i << 4);		/*lint !e701 */
			bp->data[1] = bp->data[0];  /* The checksum */
			bp->cnt = 2;
  
			if (iface->port)	{
				iface->rawsndcnt++;
				iface->lastsent = secclock();
			}
			/* slip_raw also increments sndrawcnt */
			(void) slip_raw (master, bp);
  
			(void) kpause (WAITTIME);    /* give time to start sending frame */
  
			if (sp->rx) {
				/* if frame busy, wait for a full frame (max) */
				kalarm (interval);
				kwait (&sp->rx);
			}
		}
	}
}
  
#endif /* POLLEDKISS */
  
