#ifndef _lint
#include <unistd.h>
#endif
#include "global.h"
#include "commands.h"
#ifndef MSDOS
#include <time.h>
#endif
#include "mailbox.h"
#include "files.h"


#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: mbfilter.c,v 1.16 1997/08/19 01:19:22 root Exp root $";
#endif

#ifdef MAILFILTER

extern char *reqsvr_filter_subject;
extern int reqsvr_bypass_permissions;
static char *makeone (char *buf);


#define LOOKING  0
#define PARSING  1
#define COMPLETE 2

static char *
makeone (buf)
char *buf;
{
char *temp;

	temp = strchr(buf, ':');
	if (temp)	{
		*temp++ = 0;
		return (temp);
	} else
		return (NULLCHAR);
}



int
mbfilter(fp,from, to)
FILE *fp;
const char *from;
const char *to OPTIONAL;
{
char subject[256], realfrom[128], realto[238], bid[128];
long startat;
int retval = 1, k;
FILE *fltfp;
char buf[256];
int state;
char *filename = NULLCHAR, *dirname = NULLCHAR;
char *temp, *cp, *temp2;
int override = 0;

	parseheader (fp, realfrom, subject, realto, bid, buf, &startat);
	state = LOOKING;
	fltfp = fopen (FilterFile, "r");
	if (fltfp)	{
		while (!feof (fltfp))	{
			if (fgets(buf, 128, fltfp) == NULLCHAR)
				break;
			if (feof(fltfp))
				continue;
			rip(buf);
			if (*buf == '#' || *buf == '\n')
				continue;
			if (state == LOOKING)	{
				if (*buf != ':')
					continue;
				/* check for match */
				/* check the from user */
				cp = &buf[1];
				temp = makeone (cp);
				if (*cp && *cp != '*' && strnicmp (cp, realfrom, strlen(cp)))
					continue;
				cp = temp;

				/* check the from bbs */
				temp = makeone (cp);
				temp2 = strchr (realfrom, '@');
				if (temp2)
					temp2++;
				if (*cp && *cp != '*' && (temp2 && strnicmp (cp, temp2, strlen(cp))))
					continue;
				cp = temp;

				/* check the to user */
				temp = makeone (cp);
				if (temp2)
					temp2++;
				if (*cp && *cp != '*' && strnicmp (cp, realto, strlen(cp)))
					continue;
				cp = temp;
				
				/* check the to bbs */
				temp = makeone (cp);
				temp2 = strchr (realto, '@');
				if (temp2)
					temp2++;
				if (*cp && *cp != '*' && (temp2 && strnicmp (cp, temp2, strlen(cp))))
					continue;
				cp = temp;

				/* check the bid */
				temp = makeone (cp);
				temp2 = strchr (bid, '@');
				if (temp2)
					*temp2++ = 0;
				if (*cp && *cp != '*' && strnicmp (cp, bid, strlen(cp)))
					continue;
				cp = temp;

				/* check the subject */
				if ((temp = strchr(cp, ':')) != NULLCHAR)
					*temp = 0;
				if (*cp && *cp != '*' && strstr(subject, cp) == NULLCHAR)
					continue;

				/* if found */
				state = PARSING;
			} else if (state == PARSING)	{
				if (*buf == ':')
					state = COMPLETE;
				else if (*buf == '@')
					dirname = strdup(skipwhite(&buf[1]));
				else if (*buf == '=')
					retval = atoi(skipwhite(&buf[1]));
				else if (*buf == '!')
					override = 1;
				else if (*buf == '~')	{
					temp = skipwhite (&buf[1]);
					if (*temp != ':')
						filename = strdup (temp);
					else	{
						if (!strnicmp (&temp[1], "bid", 3))
							filename = strdup (bid);
						else if (!strnicmp (&temp[1], "subject", 7))	{
							k = atoi (&temp[9]);
							temp = subject;
							while (k--)	{
								temp = skipnonwhite (temp);
								temp = skipwhite(temp);
							}
							filename = strdup (temp);
						} else if (!strnicmp (&temp[1], "temp", 4))	{
							strncpy (buf, &temp[6], 2);
							strncpy (&buf[2], "XXXXXX", 254);
							filename = strdup ((char *)mktemp (buf));
						}
						if (filename)	{
							temp = strchr (filename, '@');
							if (temp)
								*temp = 0;
							if (strlen(filename) > 12)
								filename[12] = 0;
						}
					}
					if (filename)
						(void) strlwr (filename);
				}
			}
			if (state == COMPLETE)
				break;
		}
		if ((state != LOOKING) && (filename != NULLCHAR)) 	{
			if (dirname != NULLCHAR)	{
				temp = &dirname[strlen(dirname) - 1];
				if (*temp == '/' || *temp == '\\')
					*temp = 0;
				temp2 = strrchr (filename, '\\');
				if (!temp2)
					temp2 = strrchr (filename, '/');
				if (temp2)
					temp2++;
				else
					temp2 = filename;
			} else
				temp2 = filename;

			sprintf (buf, "uploadblind %s%s%s", (dirname) ? dirname : "", (dirname) ? "/" : "", temp2);
			log(-1, "mbfilter: '%s' received", &buf[12]);
#if 1
			reqsvr_bypass_permissions = override;
			reqsvr_filter_subject = buf;		/*lint !e789 */
			(void) reqsvr (fp, from);
#endif
		}
		if (!retval)
			log(-1, "mbfilter: removed message from: %s, to: %s, bid: %s, subj: %s", realfrom, realto, bid, subject);
		(void) fclose (fltfp);
	}
	if (dirname != NULLCHAR)
		free (dirname);
	if (filename != NULLCHAR)
		free (filename);
	return (retval);
}

#endif /* MAILFILTER */
