/* POP2 Client routines -- Not recommended.
 *	Jan 92	William Allen Simpson
 *		complete re-write to match new mailreader commands
 *
 *	partly based on a NNTP client design by Anders Klemets, SM0RGV
 *	Originally authored by Mike Stockett (WA7DYX).
 *
 * History:
 *	Modified 12 May 1991 by Mark Edwards (WA6SMN) to use new timer
 *	facilities in NOS0423.  Fixed type mismatches spotted by C++.
 *	Modified 27 May 1990 by Allen Gwinn (N5CKP) for compatibility
 *	  with later releases (NOS0522).
 *	Added into NOS by PA0GRI (and linted into "standard" C)
 * 	Modified 14 June 1987 by P. Karn for symbolic target addresses,
 *	  also rebuilt locking mechanism
 *
 *	Some code culled from previous releases of SMTP.
 *	See that code for applicable copyright notices.
 */
#include "global.h"
#ifdef POP2CLIENT
#include "timer.h"
#include "proc.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: pop2cli.c,v 1.11 1997/09/07 21:18:28 root Exp root $";
#endif

extern char Badhost[];

/* Response string keys */
static char *greeting_rsp  = "+ POP2 ";

void
pop2_job(unused,v1,p2)
int unused;
void *v1;
void *p2;
{
struct mailservers *np = v1;
struct sockaddr_in fsocket;
char buf[TLINELEN];
char *cp;
FILE *wfp = NULLFILE;
int s = -1;
int folder_len;
int msg_num = 0;

	if (mailbusy (np))
		return;

	if ((fsocket.sin_addr.s_addr = resolve (np->hostname)) == 0L) {
		/* No IP address found */
		if (Mailtrace >= 1)
			log (-1, "POP2 can't resolve host '%s'", np->hostname);
		start_detached_timer (&np->timer);
		return;
	}

	fsocket.sin_family = AF_INET;
	fsocket.sin_port = IPPORT_POP2;

	s = socket (AF_INET, SOCK_STREAM, 0);
	sockmode (s, SOCK_ASCII);

	if (connect (s, (char *)&fsocket, SOCKSIZE) == -1) {
		cp = sockerr (s);
		if (Mailtrace >= 2)
			log (s, "POP2 Connect failed: %s", (cp != NULLCHAR) ? cp : "");
		goto quit;
	}

	log (s, "POP2 Connected to mailhost %s", np->hostname);

	if (mailresponse (s, buf, "banner") == -1)
		goto quit;

	if (strncmp (buf, greeting_rsp, strlen (greeting_rsp)) != 0)
		goto quitcmd;

	(void)usprintf (s, "HELO %s %s\n", np->username, np->password);

	if (mailresponse (s, buf, "HELO") == -1)
		goto quit;

	if (buf[0] != '#' || (folder_len = atoi (&(buf[1]))) == 0) {
		/* If there is no mail (the only time we get a "+"
		 * response back at this stage of the game),
		 * then just close out the connection, because
		 * there is nothing more to do!! */
		goto quitcmd;
	}

	if ((wfp = tmpfile()) == NULLFILE) {
		if ( Mailtrace >= 1 )
			log (s, "POP2 Cannot create tmp file");
		goto quitcmd;
	}

	(void)usputs (s, "READ\n");

	/* now, get the text */
	while(TRUE) {
		long msg_len;

		if (mailresponse (s, buf, "read loop") == -1)
			goto quit;

		if (buf[0] == '=' && (msg_len = atol (&(buf[1]))) > 0) {
			(void)usputs (s, "RETR\n");

			while (msg_len > 0) {
				if (recvline (s, buf, TLINELEN) == -1)
					goto quit;

				rip (buf);
				if(!strncmp (buf, "From ", 5))
					fputc ('>', wfp);

				fprintf (wfp, "%s\n", buf);

				msg_len -= (long)(strlen (buf)+2);/* Add CRLF */
			}
			(void)usputs (s, "ACKD\n");

			msg_num++;
		} else {
			break;
		}
	}

	if (folder_len > 0) {
		/* testing the result is pointless,
		 * since POP2 already deleted mail.
		 */
		copymail (buf, TLINELEN, wfp, np->mailbox);

		if (Mailtrace) {
			if (Mailquiet == 0)
				tcmdprintf ("\007");
			tcmdprintf ("New mail arrived for %s from mailhost %s\n",
				np->mailbox, np->hostname);
			smtptick (NULL);     /* wake SMTP to send that mail */
		}
	}

quitcmd:
	(void)usputs (s, "QUIT\n");

quit:
	log (s, "POP2 daemon exiting");
	close_s (s);

	if (wfp != NULLFILE)
		fclose (wfp);
	start_detached_timer (&np->timer);
}

#endif
