#include "global.h"
#include "commands.h"
#include "files.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: translat.c,v 1.11 1997/07/31 00:44:20 root Exp root $";
#endif

#ifdef TRANSLATE
char *translate (register char *searchfor, int *didwe);


char *
translate (searchfor, didwe)
register char *searchfor;
int *didwe;
{
FILE *fp;
char buf[256];
char *retval, *trans;

	retval = strdup (searchfor);
	*didwe = 0;
	sprintf (buf, "%s/translat", ETCdir);
	if ((fp = fopen (buf, "rt")) == NULL)
		return (retval);
	while (!feof(fp))	{
		(void) fgets(buf, 256, fp);
		if (feof(fp))
			continue;
		rip (buf);
		if ((*buf == '#')  || !*buf)
			continue;	/* skip comment lines */
		trans = skipwhite(buf);
		if (trans != buf)	/* can't start with white space */
			continue;
		trans = skipnonwhite(buf);
		if (!*trans)	/* invalid line - no translate name */
			continue;
		*trans++ = 0;
		trans = skipwhite(trans);
		if (strnicmp (searchfor, buf, strlen(buf)))
			continue;	/* no match */
		free (retval);
		retval = strdup (trans);
		*didwe = 1;
		break;
	}
	(void) fclose (fp);
	return (retval);
}


#endif /* TRANSLATE */
