DECLARE SUB init ()
DECLARE SUB testd (x!, y!, lat0!, lng0!, llat!, lnge!, result%)
DECLARE SUB boxes (llat!, nx%)
DECLARE SUB test (x&, y&, tbts&, bbts&, rbts&, lbts&, result%)
DECLARE SUB dirsel (sf$, dsw%)
DECLARE FUNCTION flip2& (n%)
DECLARE FUNCTION flip& (n&)
REM qb45 code to convert winAPRS DCW maps to dosAPRS maps
REM Author: Jack Cavanagh, KB4XF
REM  Version 1.1 second release Dec 97
REM Author waives all copyright for non-commercial amateur radio use
REM and assigns this code to the public domain.
REM The author waives all responsibility too!
DEFLNG A-Z
CONST pi = 3.14159
dtg! = 180! / pi
TYPE hdrtyp
        mtype AS STRING * 4
        mver AS STRING * 4
        mfname AS STRING * 32
        mtitle AS STRING * 32
        maker AS STRING * 8
        cdate AS LONG
        lbond AS LONG  'lbound is a Basic reserved word
        rbound AS LONG
        tbound AS LONG
        bbound AS LONG
        resvd1 AS STRING * 8
        tnvp AS LONG
        nlab AS LONG
        resvde AS STRING * 140
END TYPE
TYPE vectyp
        vflag AS INTEGER
        xcoord AS LONG
        ycoord AS LONG
END TYPE
TYPE tlabtyp
        tflg AS INTEGER
        xlc AS LONG
        ylc AS LONG
        mag AS INTEGER
        ltext AS STRING * 32
END TYPE
TYPE slabtyp
        sflg AS INTEGER
        xsc AS LONG
        ysc AS LONG
        symbol AS STRING * 11
        xtext AS STRING * 23
END TYPE
DIM hdr AS hdrtyp, vec AS vectyp, tlab AS tlabtyp, slab AS slabtyp
DIM SHARED msk3, msk2, msk1, msk0, dir(160) AS STRING * 12, dclr%(160)
DIM SHARED clrm%(16), mradm!, path$
DIM A(8, 80), B(8, 80)
msk3 = &HFF
msk2 = 256 * msk3
msk1 = 256 * msk2
msk0 = &HFF000000'There is a reason for this!
dsw% = 0
CLS
PRINT "winAPRS to dos ARPS map conversion code"
PRINT "Version 1.1 Jack Cavanagh, KB4XF, Dec 97"
PRINT "Please enter dos path to DCW winAPRS maps"
PRINT "default is current directory";
INPUT path$
'Remove next line for release version
IF path$ = "" THEN path$ = "c:"
CALL init
DO   'big loop
CALL dirsel(inmap$, dsw%)
IF LEFT$(inmap$, 4) = "STOP" THEN EXIT DO
PRINT
       mapf$ = inmap$
       p% = INSTR(mapf$, ".")
       mapfb$ = LEFT$(mapf$, p% - 1)
       mapfb$ = RTRIM$(mapfb$)
       l% = LEN(mapfb$)
       mapfb$ = RIGHT$(mapfb$, l% - 3)
OPEN path$ + inmap$ FOR BINARY AS #1
GET #1, 1, hdr
CLS
COLOR 7, 0
WIDTH 80, 25
PRINT
       PRINT "Map type "; hdr.mtype
       PRINT "Map version "; hdr.mver
       PRINT "File name "; hdr.mfname
       PRINT "Map name "; hdr.mtitle
       PRINT "Map maker "; hdr.maker
       'PRINT hdr.cdate This is too complicated to convert to readable form
       u0 = flip&(hdr.lbond)
       lbts = u0
       lbd! = u0 / 36000!
       v0 = flip&(hdr.tbound)
       tbts = v0
       tbd! = v0 / 36000!
       u00 = u0
       v00 = v0
       rbts = flip&(hdr.rbound)
       rbd! = rbts / 36000!
       bbts = flip&(hdr.bbound)
       bbd! = bbts / 36000!
       nvpt = flip&(hdr.tnvp)
       PRINT "Total numer of points in map "; nvpt
       nlb% = flip&(hdr.nlab)
       PRINT "Number of labels with map "; nlb%
       lat0! = 90! - tbd!
       lng0! = 180! - lbd!
       PRINT "NW corner "; lat0!; "N "; lng0!; "W"
       lat1! = 90! - bbd!
       lng1! = 180! - rbd!
       PRINT "SE corner "; lat1!; "N "; lng1!; "W"
       latc! = 90! - (tbd! + bbd!) / 2!
       lngc! = 180! - (rbd! + lbd!) / 2!
       PRINT "Map center "; latc!; "N "; lngc!; "W "
       llat! = 90! - bbd!
PRINT "Hit any key to continue"
DO WHILE INKEY$ = ""
LOOP
logf$ = mapfb$ + ".log"
OPEN logf$ FOR OUTPUT AS #4
PRINT #4, "Processing log for "; inmap$, DATE$, TIME$
PRINT #4, "File         pts    labs  lat        long"
REM Now the big DCW 5 deg x 5 deg map needs to be sub-divided into smaller maps
'       to fit the dosAPRS 3000 pts limit or at least small enough that
'       mapfix with its 18,000 pts limit can handle.  The big map will broken
'       into 10 maps vetically by 1,2,3....7 or 8 maps horizontally depending on
'       lower latitude.
WIDTH 80, 43
mhts! = 1200 * mradm!
FOR jy% = 1 TO 150 / mradm!
tt = v00 + (jy% - 1) * mhts!
bt = tt + mhts!
v0 = tt
A$ = CHR$(jy% + 96)
llat! = 90! - bt / 36000!
CALL boxes(llat!, nx%)
clatc! = COS(pi * llat! / 180)
lngstp! = 4 / (3 * clatc!)
REM lngstp! = (rbts - lbts) / nx%
FOR ix% = 1 TO nx%
dpts = 0    'vb2
nvect% = 0
lt = u00 + (ix% - 1) * mhts! * lngstp!
rt = lt + mhts! * lngstp!
lnge! = 180! - rt / 36000!
u0 = lt
B$ = CHR$(ix% + 96)
mapf$ = mapfb$ + A$ + B$ + ".dmf"
lat0! = 90 - tt / 36000!
lng0! = 180 - lt / 36000!
latc! = 90 - (tt + bt) / 72000!
lngc! = 180 - (lt + rt) / 72000!
clatc! = COS(pi * latc! / 180!)
pptsy! = 4 * 350 / (bt - tt)  'Bob likes lots of scale within reason
ppdy! = pptsy! * 36000!
pptsx! = 640 / (rt - lt) 'For local plotting only
ppdx! = pptsx! * 36000!   'For labels only
OPEN mapf$ FOR OUTPUT AS #2
PRINT #2, USING "###.####_,"; lat0!
PRINT #2, USING "####.####_,"; lng0!
PRINT #2, USING "#####.##_,"; ppdy!
PRINT #2, USING "####.####_,"; latc!
PRINT #2, USING "####.####_,"; lngc!
PRINT #2, USING "#####.##_,"; mradm!
PRINT #2, "0,Reservd"
PRINT #2, "*"; LEFT$(mapf$, 8)

CLS
SCREEN 9
LOCATE 43, 1
PRINT mapf$:
vecn% = 0
i& = 257&
vend = nvpt * 10 + 256
DO UNTIL i& > vend   'loop 1
GET #1, i&, vec
i& = i& + 10&
sflag% = vec.vflag AND &HFF
IF sflag% = &HFF THEN 'Start of a line  loop 2
   firstpt% = 0
   u = flip&(vec.xcoord)
   v = flip&(vec.ycoord)
   CALL test(u, v, tt, bt, lt, rt, result%)
   IF result% THEN firstpt% = -1'Start point is on the map
   GET #1, i&, vec
   i& = i& + 10&     'Get color from next point's byte0
   ftype% = (vec.vflag AND &HFF) MOD 16
   'clr% = ftype%
   clr% = clrm%(ftype%) 'ftype% is actually Sproul's color code
   'Debug stuff
   'IF clr% = 0 THEN clr% = 1
   'LOCATE 1, 1
   'PRINT ftype%
   IF firstpt% THEN
   dx = (u - u0)
   px% = dx * pptsy!
   sx% = dx * pptsx! 'Alternate map projection could go here
   IF px% = 0 THEN px% = 1
   dy = (v - v0)
   py% = dy * pptsy!
   sy% = py% / 4'Ditto map projection
  IF py% < 0 THEN STOP
  IF clr% <> 0 THEN
  IF result% THEN
   vecn% = vecn% + 1
   PSET (sx%, sy%), clr%'Start new line
   nvect% = nvect% + 1
   PRINT #2, "   0,   0"
   PRINT #2, USING "####_,vec####"; clr%; vecn%
   PRINT #2, USING "#####_,#####"; px%; py%
   u = flip&(vec.xcoord) 'line to 2nd point
   v = flip&(vec.ycoord)
    uold = u
    vold = v
    dx = (u - u0)
    px% = dx * pptsy!
    sx% = dx * pptsx!
    IF px% = 0 THEN px% = 1
    dy = (v - v0)
    py% = dy * pptsy!
    sy% = py% / 4
    LINE -(sx%, sy%), clr%
    PRINT #2, USING "#####_,#####"; px%; py%
    dpts = dpts + 2   'vb2
  END IF
 END IF
 END IF
ELSE 'plot next point
  IF clr% <> 0 THEN
   u = flip&(vec.xcoord) 'line to 2nd point
   v = flip&(vec.ycoord)
   CALL test(u, v, tt, bt, lt, rt, result%)
   IF (u = uold) AND (v = vold) THEN result% = 0'Double single point problem
   IF result% THEN
    dx = (u - u0)
    px% = dx * pptsy!
    sx% = dx * pptsx!
    IF px% = 0 THEN px% = 1
    dy = (v - v0)
    py% = dy * pptsy!
    sy% = py% / 4
   IF result% AND NOT firstpt% THEN 'Point is on current map but line not started
    PSET (sx%, sy%), clr%'Start new line
    PRINT #2, "   0,   0"
    PRINT #2, USING "####_,vec####"; clr%; vecn%
    PRINT #2, USING "#####_,#####"; px%; py%
    dpts = dpts + 1  'vb2
    firstpt% = -1
   ELSE
    LINE -(sx%, sy%), clr%
    PRINT #2, USING "#####_,#####"; px%; py%
    dpts = dpts + 1    'vb2
   END IF
  END IF
 END IF
END IF  'loop 2
LOOP    'loop 1
PRINT #2, "   0,  -1"
REM Now do the labels
dlab% = 0
labc% = 0
IF nlb% <> 0 THEN PRINT #2, "0, DCW Gazetter labels" 'vb2
i& = SEEK(1)
DO UNTIL labc% = nlb%
GET #1, i&, tlab
i& = i& + 44&
labc% = labc% + 1
dlng! = 180! - flip&(tlab.xlc) / 36000!
dlat! = 90! - flip&(tlab.ylc) / 36000!
CALL testd(dlng!, dlat!, lat0!, llat!, lng0!, lnge!, result%)
IF result% THEN
 mag! = flip2(tlab.mag)
 text$ = tlab.ltext
 endptr% = INSTR(text$, CHR$(0))'DCW uses null character fill vb2
 text$ = LEFT$(text$, endptr% - 1)'vb2
 PRINT #2, USING "###.####_,####.####_,####_,&"; dlat!; dlng!; mag!; text$
 dlab% = dlab% + 1
 px% = (lng0! - dlng!) * ppdx!
 sx% = px%
 py% = (lat0! - dlat!) * ppdy! / 4
 sy% = py%
 PSET (sx%, sy%), 15
 IF sy% < 5 THEN sy% = 5   'added for v1.1
 IF sy% >= 346 THEN sy% = 345
GET (0, 0)-(95, 7), A
LOCATE 1, 1
lt% = LEN(text$)
IF lt% > 12 THEN
  text$ = LEFT$(text$, 12)
ELSE
  text$ = text$ + STRING$(12 - lt%, 32)
END IF
PRINT text$;
GET (0, 0)-(95, 7), B
PUT (0, 0), A, PSET
 IF sx% < 544 THEN
  PUT (sx% + 1, sy% - 4), B, XOR
 ELSE
  PUT (sx% - 97, sy% - 4), B, XOR
 END IF
END IF
LOOP
'=================================
REM Symbols code  here - untested
i& = SEEK(1)
DO UNTIL EOF(1)
GET #1, i&, tlab
i& = i& + 44&
dlng! = 180! - flip&(slab.xsc) / 36000!
dlat! = 90! - flip&(slab.ysc) / 36000!
CALL testd(dlng!, dlat!, lat0!, lng0!, llat!, lnge!, result%)
IF result% THEN
 text$ = slab.symbol
 PRINT #2, USING "###.####_,####.####_,&"; dlat!; dlng!; text$
 px% = (lng0! - dlng!) * ppdx!
 sx% = px%
 py% = (lat0! - dlat!) * ppdy! / 4
 sy% = py%
 PSET (sx%, sy%), 5
END IF
LOOP
LOCATE 43, 1
dpts = dpts + 2 * nvect%
PRINT "File:"; mapf$; lat0!; "N"; lng0!; "W"; dpts; " pts    HAKTC";
idle: IF INKEY$ = "" THEN GOTO idle
'=================================

CLOSE 2
PRINT #4, USING "& ##### ##### ###.###  ####.###"; mapf$; dpts; dlab%; lat0!; lng0!
NEXT ix%
NEXT jy%
CLOSE 1
CLOSE 4
CLS
OPEN logf$ FOR INPUT AS #4
DO
LINE INPUT #4, dd$
PRINT dd$
LOOP UNTIL EOF(4)
CLOSE 4
PRINT
PRINT "Hit any key for next DCW file"
idl1: IF INKEY$ = "" THEN GOTO idl1

LOOP UNTIL inmap$ = "STOP" 'big loop

END

SUB boxes (llat!, nx%)
REM This determines how to sub-divide the DCW sub-tile.
REM The criteria is that the boxes are no more than
REM 4/3 mradn! nautical miles wide
wmap! = 8 * mradm! / 3
w! = 300 * COS(llat! * pi / 180!)
nx% = INT(w! / wmap!) + 1
END SUB

DEFSNG A-Z
SUB dirsel (sf$, dsw%)
STATIC nd%, kold%
1360 'DIRECTORY SELECT MENU
1370 'DIM dir$(160), dclr%(160) This must be in the main routine
IF dsw% THEN GOTO dirsel1:
1380 DEF SEG = &HB800'This is location of video RAM
1390 SCREEN 0, 0, 0
1400 CLS
     WIDTH 80, 43
     FOR kc% = 0 TO 160
     dclr%(kc%) = 7
     NEXT kc%
1410 FILES path$ + "*.map"  'Change to suit application
1420 kpt% = 0: kold% = 0
1430 FOR ip% = 160 TO 23 * 160 STEP 160
1440 FOR l% = 0 TO 3
1450 e$ = ""
1460 FOR j% = ip% + 36 * l% TO (ip% + 36 * l% + 34) STEP 2'Char. in every other loc.
1470 e$ = e$ + CHR$(PEEK(j%))
1480 NEXT j%
1490 IF INSTR(e$, ".") = 0 THEN 1530
1500 dir$(kpt%) = e$: kpt% = kpt% + 1
1510 NEXT l%, ip%
1520 DEF SEG
1530 nd% = kpt%: dir$(nd%) = "STOP"
dsw% = -1
1550 REM Re-entry point for other than first call
dirsel1:
1560 SCREEN 0, 0, 0: CLS
1570 FOR kpt% = 0 TO nd%
1580 irow% = kpt% \ 4 + 1
1590 icol% = (kpt% MOD 4) * 18 + 1
1600 LOCATE irow%, icol%
     COLOR dclr%(kpt%), 0
1610 PRINT dir$(kpt%);
1620 NEXT kpt%
1630 kpt% = kold%
1640 PRINT
1650 PRINT "USE ARROW KEYS THEN ENTER TO SELECT A MAP FILE"
1660 GOTO 1780
1670 kpt$ = INKEY$
1680 IF kpt$ = "" THEN 1670
1690 IF LEN(kpt$) = 1 THEN 1750
1700 kpt$ = RIGHT$(kpt$, 1)
1710 IF ASC(kpt$) = 72 THEN kpt% = kpt% - 4: IF kpt% < 0 THEN kpt% = knew%
1720 IF ASC(kpt$) = 80 THEN kpt% = kpt% + 4: IF kpt% > nd% THEN kpt% = kold%
1730 IF ASC(kpt$) = 77 THEN kpt% = kpt% + 1: IF kpt% > nd% THEN kpt% = nd%
1740 IF ASC(kpt$) = 75 THEN kpt% = kpt% - 1: IF kpt% < 0 THEN kpt% = 0
1750 IF kpt$ = CHR$(13) THEN sf$ = dir$(kpt%): GOTO 1830
1760 LOCATE kold% \ 4 + 1, 18 * (kold% MOD 4) + 1
1770 COLOR dclr%(kold%), 0: PRINT dir$(kold%);
1780 jrow% = kpt% \ 4 + 1
     JCOL% = 18 * (kpt% MOD 4) + 1
     LOCATE jrow%, JCOL%
     OLDCLR% = dclr%(kpt%)
1790 COLOR 4, 0: PRINT dir$(kpt%);
1800 kold% = kpt%
1820 GOTO 1670
1830 kold% = kpt%
     LOCATE jrow%, JCOL%
     dclr%(kpt%) = 11
     COLOR 3, 0
     PRINT dir$(kpt%)
     IF kold% < nd% THEN kold% = kold% + 1' Auto increment if not last entry

END SUB

FUNCTION flip& (n&)
REM This converts long intgers in big endian to little endian
DEFLNG A-Z
byt0 = n& AND msk0
byt1 = n& AND msk1
byt2 = n& AND msk2
byt3 = n& AND msk3
'shift to left
byt3 = byt3 * &H1000000
byt2 = byt2 * &H100
'shift to right
byt0 = byt0 / &H1000000
byt0 = byt0 AND msk3 'Take care of any sign extension in a brute force way
byt1 = byt1 / &H100
flip& = byt0 + byt1 + byt2 + byt3

END FUNCTION

FUNCTION flip2 (n%)
REM This converts two byte integers from big endian to little endian
byt0 = n% AND msk3
byt1 = n% AND msk2
byt0 = byt0 * &H100
byt1 = byt1 / &H100
byt1 = byt1 AND &HFF 'sign extension
flip2 = byt0 + byt1

END FUNCTION

SUB init
DIM tln(6)  AS STRING * 50, featpt%(6), sel(6) AS STRING * 3, tclr%(15)
CLS
FOR i% = 0 TO 15:  clrm%(i%) = 0: NEXT i%
clrm%(0) = 11 'Politcal Ocean boundaries
clrm%(3) = 3  'River & streams
clrm%(6) = 8  'Railrods
clrm%(7) = 7  'Contour lines
clrm%(10) = 12 'Roads
clrm%(12) = 14 'Populated places
COLOR 7, 0
FOR i% = 0 TO 15
tclr%(i%) = clrm%(i%)
NEXT i%
tln(1) = "        RD       All roads"
tln(2) = "        PP       Populated places"
tln(3) = "        P/O      Politcal/Ocean boundaries"
tln(4) = "        RR       Railroads"
tln(5) = "        ST       Rivers, Stream and lakes"
tln(6) = "        TO       1000ft contour lines"
featpt%(1) = 10: sel(1) = "{Y}"
featpt%(2) = 12: sel(2) = "{Y}"
featpt%(3) = 0: sel(3) = "{Y}"
featpt%(4) = 6: sel(4) = "{Y}"
featpt%(5) = 3: sel(5) = "{Y}"
featpt%(6) = 7: sel(6) = "{N}"
PRINT "WinAPRS DCW map to dosAPRS map conversion"
PRINT "Version 1.1 Dec 1997"
PRINT "Author: Jack Cavanagh, KB4XF"
PRINT
PRINT " The DCW maps have many features available. Not all of these"
PRINT "will be of interest to dosAPRS users.  In addition, some of colors"
PRINT "assigned to features do not follow the dosAPRS convention. This"
PRINT "initialization process gives the user the chance to skip the"
PRINT "conversion of some feature and to set the colors for all features"
PRINT
PRINT "The initial colors are the closest  match to the dosAPRS convention"
PRINT
PRINT "Hit any key to continue"
PRINT "Where's the any key?"
q$ = ""
DO
q$ = INKEY$
LOOP UNTIL q$ <> ""
   CLS
   PRINT
   PRINT "Use up/down arrow keys to move between feature"
   PRINT "The 'S' key toggles selection of features"
   PRINT "The left/right arrow keys change the color for this feature "
   PRINT "The 'ENTER' key terminates selection and color change"
   PRINT
   LOCATE 7, 1
   PRINT "Select   Feature   Description"
kpt$ = ""
kpt% = 8
c% = 89
 DO WHILE done% = 0
   LOCATE 8, 1, 1
   COLOR tclr%(featpt%(1)), 0
   PRINT sel(1); tln(1)
   COLOR tclr%(featpt%(2)), 0
   PRINT sel(2); tln(2)
   COLOR tclr%(featpt%(3)), 0
   PRINT sel(3); tln(3)
   COLOR tclr%(featpt%(4)), 0
   PRINT sel(4); tln(4)
   COLOR tclr%(featpt%(5)), 0
   PRINT sel(5); tln(5)
   COLOR tclr%(featpt%(6)), 0
   PRINT sel(6); tln(6)
 LOCATE kpt%, 1, 1


  DO
   kpt$ = INKEY$
  LOOP UNTIL kpt$ <> ""
 IF LEN(kpt$) = 2 THEN
  kpt$ = RIGHT$(kpt$, 1)
 END IF
 IF ASC(kpt$) = 72 THEN kpt% = kpt% - 1: IF kpt% < 8 THEN kpt% = 13
 IF ASC(kpt$) = 80 THEN kpt% = kpt% + 1: IF kpt% > 13 THEN kpt% = 8
 IF ASC(kpt$) = 77 THEN
    pt% = featpt%(kpt% - 7)
    tclr%(pt%) = tclr%(pt%) + 1
     IF tclr%(pt%) > 15 THEN tclr%(pt%) = 0
 END IF
 IF ASC(kpt$) = 75 THEN
    pt% = featpt%(kpt% - 7)
    tclr%(pt%) = tclr%(pt%) - 1
      IF tclr%(pt%) < 0 THEN tclr%(pt%) = 15
 END IF
 IF UCASE$(kpt$) = "S" THEN
    c% = ASC(MID$(sel(kpt% - 7), 2, 1))
    c% = 167 - c%
    MID$(sel(kpt% - 7), 2, 1) = CHR$(c%)
 END IF
 IF kpt$ = CHR$(13) THEN done% = -1
 LOOP
FOR i% = 1 TO 6
 j% = featpt%(i%)
 IF sel(i%) = "{Y}" THEN
   clrm%(j%) = tclr%(j%)
 ELSE
   clrm%(j%) = 0
 END IF
NEXT i%
CLS
COLOR 7, 0
PRINT "Map radius:"
PRINT "APRS maps have a 4:3 horizontal/vertical aspect ratio"
PRINT "DCW maps are based on a 5 deg lat. by 5 deg long. 'tile.'"
PRINT "A tile is always 300 nautical miles (540km) in the N-S direction. "
PRINT "Its width in the E-W varies from 300 nm at the equator to"
PRINT "only 150 nm at 60 deg N and goes rapidly to zero further "
PRINT "north towards the pole. This program produces a grid of"
PRINT "maps that 5x4 near the equator or 5x2 in the far north for"
PRINT "a 30 mile radius map"
PRINT
PRINT "Please enter a map radius from the following values:"
PRINT "Recommended values:"
PRINT " 30 nm - this is about the biggest dos map one came make;"
PRINT "         any bigger gets too large for dosAPRS."
PRINT " 15 nm - a good value that faciltates the use of MAPFIX"
PRINT "         to splice maps together."
PRINT " 7.5 nm - use only in very densely featured areas"
ok% = 0
DO
INPUT "Your choice", mradm!
IF mradm! <= 50! AND mradm! >= 5 THEN
  ok% = -1
ELSE
  PRINT mradm!; " is not a good value, try again. but"
  PRINT "this time use a value between 5 and 50 nm"
END IF
LOOP UNTIL ok%
COLOR 7, 0

END SUB

SUB test (x, y, tbts, bbts, lbts, rbts, result%)
REM This tests to see if the point (x,y) is one the current map
REM Units are all in tenths of a second
result% = 0
IF x >= lbts AND x <= rbts THEN
    IF y >= tbts AND y <= bbts THEN
    result% = -1
    END IF
END IF

END SUB

SUB testd (x!, y!, lat0!, llat!, lng0!, lnge!, result%)
REM This tests to see if the point (x,y) is one the current map
REM Units are all in decimal degrees
result% = 0
IF x! >= lnge! AND x! <= lng0! THEN
    IF y! >= llat! AND y! <= lat0! THEN
    result% = -1
    END IF
END IF

END SUB

