'Heavily modified by W7KKE to create .hst file from NWS wx bullitens

'    Modification history
' 17FEB96 W7KKE Incorporated max winds radius for Hurricanes and TS.
' 25JUN96 W7KKE Corrected formats for NWS Web page downloads
' 29JUN96 W7KKE Corrected for inland position reports
' 03JUL96 W7KKE Corrected for 'relocated' position reports
'                Also added capability to read files with lines either ending
'                with CR/LF or with just LF.
' 04JUL96 W7KKE Uploaded to tapr.org
' 06JUL96 W7KKE Corrected input/output file entry and re-uploaded to tapr
'               as WXHURR2 and then WXHURR3 (same day)
' 30AUG96 W7KKE 1 - Corrected error in .BK file when latitude and longitude
'               minutes <10.
'               2 - Changed naming scheme so that multiple storms would not
'               wipe out each other's forecast positions.

ts = 0
hs = 0
td = 0
noLF = 0

CLS
PRINT "                        APRS Huricane Position Extractor"
PRINT "                                   by W7KKE"
PRINT
PRINT "This program reads the marine weather warnings produced by the National"
PRINT "Hurricane Center and produces an APRS backup file ( .BK). This file"
PRINT "can then be imported into APRS and will produce a plot of the storm's"
PRINT "current position, radius of maximum storm winds, and projected track."
PRINT
PRINT "You can find these warnings at  http://www.nhc.noaa.gov/products.html"
PRINT
PRINT "          Choose 'Forecast/Advisory' option for the storm of interest."
PRINT
PRINT
PRINT "When running APRS, use the (F)ile (L)oad <path/filename> or"
PRINT "(F)ile (A)ppend <path/filename>. (The append will not delete the"
PRINT "contents of your current 'P' screen."
PRINT
PRINT "The projected track uses UTC date/time as object name on the APRS screen."
PRINT

INPUT "Enter path and filename of warning message"; f$
'f$ = "c:\aprsmaps\borisxx.txt"  'test message"
OPEN f$ FOR INPUT AS #1

PRINT
INPUT "Enter path and filename to save APRS backup file"; fo$
'fo$ = "c:\aprs\baks\hur_test.bk"
OPEN fo$ FOR OUTPUT AS #2

CLS
Main:
  DO WHILE NOT EOF(1)
     LINE INPUT #1, a$
     'PRINT a$ 'for debugging
  LOOP

CLOSE #1

'Check for very long a$ which indicates the message does not have CR/LF
'combination at end of each line, but only LF character.
IF LEN(a$) > 100 THEN
  noLF = 1
  OPEN "WXTEST.TMP" FOR OUTPUT AS #3
  FOR X = 1 TO LEN(a$)
     Y$ = MID$(a$, X, 1)
     IF ASC(Y$) = 10 THEN
       PRINT #3, CHR$(13); : PRINT #3, CHR$(10);
       PRINT
     ELSE
       PRINT #3, Y$;
       PRINT Y$;
     END IF
  NEXT X
  CLOSE #3
END IF

PRINT

INPUT "Press any key to continue"; in$

IF noLF = 1 THEN
   OPEN "WXTEST.TMP" FOR INPUT AS #1
ELSE
   OPEN f$ FOR INPUT AS #1
END IF

PRINT
PRINT "Saving following APRS backup file data as "; fo$

dt$ = RIGHT$(DATE$, 4) 'Retrieves current year for cuing program
 
  DO WHILE NOT EOF(1)
     INPUT #1, a$
     LOCATE 25, 1: PRINT "Parsing: "; LEFT$(a$ + SPACE$(70), 70);
     a = INSTR(a$, "NNNN"): IF a > 0 THEN GOSUB BeginNEW
     a = INSTR(a$, "ZCZC"): IF a > 0 THEN GOSUB BeginNEW
     a = INSTR(a$, dt$): IF a > 0 THEN GOSUB GetDate
     a = INSTR(a$, "TROPICAL DEPRESSION"): IF a > 0 THEN GOSUB Tropical
     a = INSTR(a$, "TROPICAL STORM"): IF a > 0 THEN GOSUB Tropical
     a = INSTR(a$, "HURRICANE"): IF a > 0 THEN GOSUB Tropical
     a = INSTR(a$, "MOVEMENT TOWARD"): IF a > 0 THEN GOSUB movement
     a = INSTR(a$, "CENTRAL PRESSURE"): IF a > 0 THEN GOSUB Pressure
     a = INSTR(a$, "MAX SUSTAINED"): IF a > 0 THEN GOSUB Winds
     a = INSTR(a$, "FORECAST VALID"): IF a > 0 THEN GOSUB Forecast
     a = INSTR(a$, "MAX WIND"): IF a > 0 THEN GOSUB Winds
     a = INSTR(a$, "OUTLOOK VALID"): IF a > 0 THEN GOSUB Forecast
     a = INSTR(a$, "PRESENT MOVEMENT NEARLY STATIONARY"): IF a > 0 THEN GOSUB movement


     IF Pos$ <> "" AND CSpd$ <> "" AND Cmts$ <> "" THEN
        GOSUB BuildPOS
        GOSUB SendNext
     END IF
  LOOP
  END
'********************** SUBROUTINES FOLLOW ***************************

BeginNEW: REM Clear everything to get ready for new message
          Pos$ = "": CSpd$ = "": name$ = ""
          TropStrm = 0
          RETURN

GetDate:  dtg$ = "******/": IF a > 3 THEN Day$ = MID$(a$, a - 3, 2)
          b = INSTR(a$, "Z"): IF b > 4 THEN dtg$ = Day$ + MID$(a$, b - 4, 4) + "z"
          RETURN

Tropical: 'sym$ = "/": REM symbol for a dot for forecast posits
          b = INSTR(a$, "ADVISORY NUMBER")
          IF b > 0 THEN  ' Get the storm NAME
             'sym$ = "@" 'symbol for a hurricane - use for first posit
             Num$ = MID$(a$, b + 17)
             IF LEFT$(a$, 9) = "HURRICANE" THEN
                c = INSTR(a + 11, a$, " ")' Find ending space of name
                name$ = MID$(a$, a + 10, c - (a + 10)) + Num$
                hs = 1
             END IF
             IF LEFT$(a$, 14) = "TROPICAL STORM" THEN
                c = INSTR(16, a$, " ")' Find ending space of name
                name$ = MID$(a$, 16, c - 16) + Num$
                ts = 1
             END IF
           
             IF LEFT$(a$, 19) = "TROPICAL DEPRESSION" THEN
                c = INSTR(21, a$, " ")' Find ending space of name
                name$ = MID$(a$, 21, c - 21) + Num$
                td = 1
             END IF


       'Adjust the name so string length is correct for APRS position report
            IF LEN(name$) < 9 THEN
              a1 = LEN(name$)
              name$ = name$ + SPACE$(9 - a1)
            END IF
         
            IF LEN(name$) > 9 THEN name$ = LEFT$(name$, 9)
     
          END IF

         'Save the storm's name for use with the forecast position reports.
         '(name$ is also used for the forecast posits.)
         storm$ = name$

          b = INSTR(a$, "LOCATED NEAR") ' Get the POSIT
          IF b > 0 THEN
              L = b + 13
              T = 0
              TropStrm = 1
              GOSUB ParsePos
          END IF

          d = INSTR(a$, " INLAND NEAR") ' For storms having moved inland
          IF d > 0 THEN
              L = d + 13
              T = 0
              TropStrm = 1
              GOSUB ParsePos
          END IF
         
           e = INSTR(a$, "RELOCATED NEAR") ' For relocated position warnings
          IF e > 0 THEN
              L = e + 15
              T = 0
              TropStrm = 1
              GOSUB ParsePos
          END IF
        
          RETURN

ParsePos: REM Parse out LAT/LONG beginning at location L and TIME at T
          REM also find TIME if after L
    Lat = VAL(MID$(a$, L, 4)): latd = INT(Lat): latm = Lat - latd
    Lon = VAL(MID$(a$, L + 6, 5)): LONd = INT(Lon): Lonm = Lon - LONd

    IF BFLAG = 0 THEN
      PRINT #2, "c," + STR$(Lat) + "," + STR$(Lon) + " , 1024"'For backup file only
      PRINT "c," + STR$(Lat) + " ," + STR$(Lon) + " , 1024"'For backup file only
      BFLAG = 1
    END IF

    latm1$ = STR$(INT(latm * 60))
    Lat$ = MID$(STR$(latd), 2, 2)
    X$ = MID$(STR$(INT(latm * 60)), 2, 2)
    IF LEN(X$) = 1 THEN X$ = "0" + X$
    Lat$ = Lat$ + X$
    Lat$ = Lat$ + ".00N"
   
    LONd$ = STR$(LONd)
    Lonm$ = STR$(INT(Lonm * 60))
    Lonm$ = RIGHT$(Lonm$, LEN(Lonm$) - 1)
    X$ = MID$(STR$(INT(Lonm * 60)), 2, 2)
    IF LEN(X$) = 1 THEN Lonm$ = "0" + X$
    IF VAL(Lonm$) = 0 THEN Lonm$ = "00"

    Lon$ = RIGHT$(LONd$, 3) + Lonm$ + ".00W"
    IF MID$(Lon$, 1, 1) = " " THEN MID$(Lon$, 1, 1) = "0"

    c = INSTR(a$, " AT "): IF c > L THEN T = c + 4
    IF T > 0 THEN
       TIM$ = MID$(a$, T, 2) + MID$(a$, T + 3, 5)
       MID$(TIM$, 7, 7) = "z"
    ELSE
       TIM$ = "******/"
    END IF
   
    Pos$ = Lat$ + "/" + Lon$
    RETURN

Pressure: Pres$ = "/" + MID$(a$, a + 17, 4) + "mb "
          RETURN

movement: b = INSTR(a$, "DEGREES")  'Get the direction
          IF b > 4 THEN CSpd$ = MID$(a$, b - 4, 3)
          c = INSTR(a$, " KT")
          IF c > b + 10 THEN CSpd$ = CSpd$ + "/" + MID$(a$, c - 2, 2)
          IF b = 0 THEN CSpd$ = "355/00"'dummy value for stationary storm

           IF hs = 1 THEN CSpd$ = CSpd$ + "/HC/"
           IF ts = 1 THEN CSpd$ = CSpd$ + "/TS/"
           IF td = 1 THEN CSpd$ = CSpd$ + "/TD/"
          RETURN

Winds:    b = INSTR(a$, " KT")
          Cmts$ = ""
          IF b > 4 THEN
          
           Cmts1$ = MID$(a$, b - 4, 7)
           Cmts2$ = MID$(a$, b + 6, 9)
           Cmts$ = Cmts1$ + " " + Cmts2$
        
           IF MID$(a$, b + 4, 4) = "WITH" THEN
             WWW$ = MID$(a$, b - 3, 3)
             b = INSTR(a$, "GUSTS TO")
             GGG$ = MID$(a$, b + 9, 3)
           
             'Convert comments string to new APRS hurricane report format
              Cmts$ = WWW$ + "^" + GGG$ + "/" + MID$(Pres$, 2, 4)
            
             'Pickup radius of storm winds
             'RRR = max radius of HC winds
             'rrr1 = max radius of TS winds
              b = 0
              i = 0
             DO WHILE b = 0 AND td = 0
              b = INSTR(a$, "ALL QUADRANT")'Marks the end of wind radius info
             INPUT #1, a$
                 i = i + 1
                IF LEN(a$) > 0 THEN
                   IF LEFT$(a$, 2) = "64" THEN
                      RNE$(i) = MID$(a$, 13, 3)
                      RSE$(i) = MID$(a$, 19, 3)
                      RSW$(i) = MID$(a$, 25, 3)
                      RNW$(i) = MID$(a$, 31, 3)
                   END IF

                   IF LEFT$(a$, 2) = "50" THEN
                      RNE$(i) = MID$(a$, 13, 3)
                      RSE$(i) = MID$(a$, 19, 3)
                      RSW$(i) = MID$(a$, 25, 3)
                      RNW$(i) = MID$(a$, 31, 3)
                   END IF
                END IF
             LOOP
            
             IF hs = 1 THEN
                'find largest hurricane wind radius in the four quadrants
                rrr$ = RNE$(1)'radius of hurricane winds
                IF rrr$ < RSE$(1) THEN rrr$ = RSE$(1)
                IF rrr$ < RSW$(1) THEN rrr$ = RSW$(1)
                IF rrr$ < RNW$(1) THEN rrr$ = RNW$(1)

                rrr1$ = RNE$(2) 'radius of tropical storm winds
                IF rrr1$ < RSE$(2) THEN rrr$ = RSE$(2)
                IF rrr1$ < RSW$(2) THEN rrr$ = RSW$(2)
                IF rrr1$ < RNW$(2) THEN rrr$ = RNW$(2)
                Cmts$ = Cmts$ + ">" + rrr$ + "&" + rrr1$
            
             END IF
             IF ts = 1 THEN
                rrr$ = "000" 'radius of hurricane winds (arn't any)
                rrr1$ = RNE$(1) 'radius of tropical storm winds
                IF rrr1$ < RSE$(1) THEN rrr$ = RSE$(1)
                IF rrr1$ < RSW$(1) THEN rrr$ = RSW$(1)
                IF rrr1$ < RNW$(1) THEN rrr$ = RNW$(1)
                Cmts$ = Cmts$ + ">" + rrr$ + "&" + rrr1$
             END IF

           END IF
          END IF
          RETURN


Forecast: b = INSTR(a$, "Z")
          IF b > 20 AND TropStrm THEN
             L = b + 2: T = b - 7
             GOSUB ParsePos
            
             ' Use the first letter of the storm and the Forecast TIME as
             'the NAME for the forecast position report.
             name$ = LEFT$(storm$, 1) + MID$(a$, T, 8)
             CSpd$ = "Wind"
             TIM$ = dtg$' Insert Date/Time of the message
          END IF
          RETURN

BuildPOS: REM Assemble the pieces into a complete OBJECT report.
'Assign symbol based on whether named fix or fcst posit.
          IF LEN(name$) > 0 THEN
           IF MID$(name$, 4, 1) = "/" THEN sym$ = "/" ELSE sym$ = "@"
          END IF
  
   'Following is to create a backup file.
p$ = "p," + LEFT$(name$ + " " + LEFT$(TIM$, 6) + " @" + TIM$ + Pos$ + sym$ + CSpd$ + Cmts$, 75)
  
     

   RETURN

SendNext: REM send the position to file
     IF p$ <> oldp$ THEN
       PRINT #2, p$
       PRINT p$
       oldp$ = p$
       Cmts$ = "" 'This prevents bad output on next loop
     END IF
   RETURN

